# flake8: noqa
# generated by datamodel-codegen:
#   filename:  openapi.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Any, Dict, List, Optional, Union
from uuid import UUID

from pydantic import BaseModel, EmailStr, Field


class ActionDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class ActionState(Enum):
    NOT_FOUND = "NOT_FOUND"
    CREATED = "CREATED"
    PREPARING = "PREPARING"
    WITH_PROBLEMS = "WITH_PROBLEMS"
    STARTING = "STARTING"
    STARTED = "STARTED"
    NOT_STARTED = "NOT_STARTED"
    STOPPING = "STOPPING"
    STOPPED = "STOPPED"
    DELETING = "DELETING"
    PENDING = "PENDING"
    FAILED = "FAILED"
    NOMAD_ERROR = "NOMAD_ERROR"
    NOMAD_JOB_ERROR = "NOMAD_JOB_ERROR"
    OBTAINING_MODELS_VENV = "OBTAINING_MODELS_VENV"
    INITIALIZING_VENV = "INITIALIZING_VENV"
    COMPLETE = "COMPLETE"
    CANCELLED = "CANCELLED"
    EXECUTION_NOT_FOUND = "EXECUTION_NOT_FOUND"
    EXECUTION_RESULT_ERROR = "EXECUTION_RESULT_ERROR"
    NO_RESULTS_PATH_VALID = "NO_RESULTS_PATH_VALID"
    NO_EXECUTION = "NO_EXECUTION"


class ActionStateReturning(BaseModel):
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    state: ActionState
    is_running: bool = Field(..., title="Is Running")
    is_startable: bool = Field(..., title="Is Startable")
    is_stoppable: bool = Field(..., title="Is Stoppable")


class ActionStats(BaseModel):
    executions: int = Field(..., title="Executions")
    last_run: Optional[datetime] = Field(None, title="Last Run")


class ActionUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")


class AllocClientStatus(Enum):
    pending = "pending"
    running = "running"
    complete = "complete"
    failed = "failed"
    lost = "lost"
    unknown = "unknown"


class AllocDesiredStatus(Enum):
    run = "run"
    stop = "stop"
    evict = "evict"


class AssetCreating(BaseModel):
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    version: str = Field(..., title="Version")
    path: str = Field(..., title="Path")
    kind: str = Field(..., title="Kind")
    meta: Dict[str, Any] = Field(..., title="Meta")


class AssetDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class AssetListingLatest(BaseModel):
    org_id: Optional[UUID] = Field(None, title="Org Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class AssetReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")
    name: Optional[str] = Field(None, title="Name")
    version: Optional[str] = Field(None, title="Version")
    kind: Optional[str] = Field(None, title="Kind")
    path: Optional[str] = Field(None, title="Path")


class AssetReadingLatest(BaseModel):
    name: str = Field(..., title="Name")
    broker_id: UUID = Field(..., title="Broker Id")


class AssetReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    version: str = Field(..., title="Version")
    kind: str = Field(..., title="Kind")
    path: str = Field(..., title="Path")
    meta: Dict[str, Any] = Field(..., title="Meta")
    num_used_by: int = Field(..., title="Num Used By")


class AssetUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    version: Optional[str] = Field(None, title="Version")
    kind: Optional[str] = Field(None, title="Kind")
    path: Optional[str] = Field(None, title="Path")
    meta: Optional[Dict[str, Any]] = Field(None, title="Meta")


class BodyApiV1OauthTokenApiV1OauthTokenPost(BaseModel):
    grant_type: Optional[str] = Field(
        "client_credentials",
        description="OAuth2 Grant Type",
        regex="client_credentials",
        title="Grant Type",
    )
    scope: Optional[str] = Field("", description="OAuth2 Scope", title="Scope")
    client_id: Optional[str] = Field(
        None, description="Prodigy Teams Broker Client ID", title="Client Id"
    )
    client_secret: Optional[str] = Field(
        None, description="Prodigy Teams Broker Client Secret", title="Client Secret"
    )


class BrokerAuthenticated(BaseModel):
    access_token: str = Field(..., title="Access Token")
    expires_in: int = Field(..., title="Expires In")
    token_type: Optional[str] = Field("bearer", title="Token Type")


class BrokerDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class BrokerPathCreating(BaseModel):
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")


class BrokerPathDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class BrokerPathReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")
    name: Optional[str] = Field(None, title="Name")
    path: Optional[str] = Field(None, title="Path")


class BrokerPathReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")


class BrokerPathUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")


class BrokerReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    address: Optional[str] = Field(None, title="Address")
    state: Optional[str] = Field(None, title="State")
    region: Optional[str] = Field(None, title="Region")
    zone: Optional[str] = Field(None, title="Zone")
    cloud_provider: Optional[str] = Field(None, title="Cloud Provider")
    cloud_account: Optional[str] = Field(None, title="Cloud Account")
    cloud_region: Optional[str] = Field(None, title="Cloud Region")


class BrokerRegistering(BaseModel):
    address: str = Field(..., title="Address")
    state: str = Field(..., title="State")


class BrokerRegistrationCreating(BaseModel):
    name: str = Field(..., title="Name")
    cloud_provider: str = Field(..., title="Cloud Provider")
    cloud_account: Optional[str] = Field(None, title="Cloud Account")
    cloud_region: Optional[str] = Field(None, title="Cloud Region")


class BrokerRegistrationReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    org_id: UUID = Field(..., title="Org Id")
    name: str = Field(..., title="Name")
    registration_token: UUID = Field(..., title="Registration Token")
    claimed: bool = Field(..., title="Claimed")
    expiration: datetime = Field(..., title="Expiration")


class BrokerReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    name: str = Field(..., title="Name")
    address: str = Field(..., title="Address")
    state: str = Field(..., title="State")
    cloud_provider: str = Field(..., title="Cloud Provider")
    cloud_account: Optional[str] = Field(None, title="Cloud Account")
    cloud_region: Optional[str] = Field(None, title="Cloud Region")
    client_id: UUID = Field(..., title="Client Id")
    client_secret: str = Field(..., title="Client Secret")


class BrokerUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    address: Optional[str] = Field(None, title="Address")


class CackQuerying(BaseModel):
    source: str = Field(..., title="Source")
    required: bool = Field(..., title="Required")
    fields: Optional[List[str]] = Field(None, title="Fields")
    filters: Optional[Dict[str, Any]] = Field({}, title="Filters")
    predicates: Optional[List[Dict[str, Any]]] = Field([], title="Predicates")
    relations: Optional[List[CackQuerying]] = Field([], title="Relations")
    key: Optional[str] = Field("", title="Key")
    return_list: Optional[bool] = Field(None, title="Return List")
    slice_start: Optional[int] = Field(None, title="Slice Start")
    slice_stop: Optional[int] = Field(None, title="Slice Stop")
    slice_step: Optional[int] = Field(None, title="Slice Step")


class DatasetCreating(BaseModel):
    name: str = Field(..., title="Name")
    broker_id: UUID = Field(..., title="Broker Id")
    kind: str = Field(..., title="Kind")


class DatasetDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class DatasetReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    kind: Optional[str] = Field(None, title="Kind")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class DatasetReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    broker_id: UUID = Field(..., title="Broker Id")
    kind: str = Field(..., title="Kind")
    num_used_by: int = Field(..., title="Num Used By")


class DatasetUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    kind: Optional[str] = Field(None, title="Kind")


class Empty(BaseModel):
    pass


class EmptyResponse(BaseModel):
    pass


class GroupAuthorizing(BaseModel):
    id: UUID = Field(..., title="Id")
    role: str = Field(..., title="Role")
    resource_type: str = Field(..., title="Resource Type")
    resource_id: UUID = Field(..., title="Resource Id")


class GroupCreating(BaseModel):
    name: str = Field(..., title="Name")
    org_id: UUID = Field(..., title="Org Id")


class GroupDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class GroupPopulating(BaseModel):
    id: UUID = Field(..., title="Id")
    user_id: UUID = Field(..., title="User Id")


class GroupReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    org_id: Optional[UUID] = Field(None, title="Org Id")


class GroupUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")


class InvitationCreating(BaseModel):
    org_id: UUID = Field(..., title="Org Id")
    email: str = Field(..., title="Email")
    hash: str = Field(..., title="Hash")
    strict: Optional[bool] = Field(False, title="Strict")
    vars: Optional[Dict[str, Any]] = Field({}, title="Vars")


class InvitationDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class InvitationReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    email: Optional[str] = Field(None, title="Email")
    hash: Optional[str] = Field(None, title="Hash")
    claimed: Optional[bool] = Field(None, title="Claimed")


class InvitationReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    email: str = Field(..., title="Email")
    hash: str = Field(..., title="Hash")
    claimed: bool = Field(..., title="Claimed")


class InvitationUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    claimed: bool = Field(..., title="Claimed")


class JobStatus(Enum):
    pending = "pending"
    running = "running"
    dead = "dead"


class JobType(Enum):
    task = "task"
    action = "action"


class NomadAttemptResultReading(BaseModel):
    id: UUID = Field(..., title="Id")
    eval_id: UUID = Field(..., title="Eval Id")


class NomadAttemptResultReturning(BaseModel):
    success: bool = Field(..., title="Success")
    error_message: Optional[str] = Field(None, title="Error Message")


class NomadAttemptUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    pam_error: Optional[Dict[str, Any]] = Field(None, title="Pam Error")
    validation_error: Optional[Dict[str, Any]] = Field(None, title="Validation Error")
    nomad_error: Optional[Dict[str, Any]] = Field(None, title="Nomad Error")
    evaluation_id: Optional[UUID] = Field(None, title="Evaluation Id")
    eval_create_index: Optional[int] = Field(None, title="Eval Create Index")
    job_modify_index: Optional[int] = Field(None, title="Job Modify Index")


class NomadEventCreating(BaseModel):
    broker_id: UUID = Field(..., title="Broker Id")
    index: int = Field(..., title="Index")
    topic: str = Field(..., title="Topic")
    type: str = Field(..., title="Type")
    key: str = Field(..., title="Key")
    payload: Dict[str, Any] = Field(..., title="Payload")
    filter_keys: Optional[List[str]] = Field([], title="Filter Keys")
    namespace: Optional[str] = Field("", title="Namespace")


class NomadEventDetail(BaseModel):
    created: Optional[datetime] = Field(None, title="Created")
    updated: Optional[datetime] = Field(None, title="Updated")
    id: Optional[UUID] = Field(None, title="Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")
    action_id: Optional[UUID] = Field(None, title="Action Id")
    task_id: Optional[UUID] = Field(None, title="Task Id")
    index: Optional[int] = Field(None, title="Index")
    topic: Optional[str] = Field(None, title="Topic")
    type: Optional[str] = Field(None, title="Type")
    key: Optional[str] = Field(None, title="Key")
    namespace: Optional[str] = Field(None, title="Namespace")
    payload: Dict[str, Any] = Field(..., title="Payload")


class NomadEventGetIndex(BaseModel):
    latest_index: int = Field(..., title="Latest Index")


class NomadEventIndex(BaseModel):
    index: int = Field(..., title="Index")


class NomadEventReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")
    action_id: Optional[UUID] = Field(None, title="Action Id")
    task_id: Optional[UUID] = Field(None, title="Task Id")
    index: Optional[int] = Field(None, title="Index")
    topic: Optional[str] = Field(None, title="Topic")
    type: Optional[str] = Field(None, title="Type")
    key: Optional[str] = Field(None, title="Key")
    namespace: Optional[str] = Field(None, title="Namespace")


class NomadJobStub(BaseModel):
    CreateIndex: int = Field(..., title="Createindex")
    Datacenters: List[str] = Field(..., title="Datacenters")
    ID: UUID = Field(..., title="Id")
    JobModifyIndex: int = Field(..., title="Jobmodifyindex")
    ModifyIndex: int = Field(..., title="Modifyindex")
    Name: str = Field(..., title="Name")
    Namespace: Optional[str] = Field(None, title="Namespace")
    ParentID: Optional[UUID] = Field(None, title="Parentid")
    Periodic: Optional[bool] = Field(None, title="Periodic")
    Priority: Optional[int] = Field(None, title="Priority")
    Stable: Optional[bool] = Field(None, title="Stable")
    Status: JobStatus
    StatusDescription: str = Field(..., title="Statusdescription")
    Stop: bool = Field(..., title="Stop")
    SubmitTime: int = Field(..., title="Submittime")
    Type: Optional[str] = Field(None, title="Type")


class NomadJobsIds(BaseModel):
    jobs_ids: List[UUID] = Field(..., title="Jobs Ids")


class NotificationCreating(BaseModel):
    user_id: UUID = Field(..., title="User Id")
    type: str = Field(..., title="Type")
    message: str = Field(..., title="Message")
    is_read: bool = Field(..., title="Is Read")
    details: Dict[str, Union[str, int, float]] = Field(..., title="Details")


class NotificationDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class NotificationReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    user_id: Optional[UUID] = Field(None, title="User Id")
    is_read: Optional[bool] = Field(None, title="Is Read")


class NotificationReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    user_id: UUID = Field(..., title="User Id")
    type: str = Field(..., title="Type")
    message: str = Field(..., title="Message")
    is_read: bool = Field(..., title="Is Read")
    details: Dict[str, Any] = Field(..., title="Details")


class NotificationUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    is_read: Optional[bool] = Field(None, title="Is Read")
    message: Optional[str] = Field(None, title="Message")
    details: Optional[Dict[str, Union[str, int, float]]] = Field(None, title="Details")


class ObjectValidation(BaseModel):
    errors: Dict[str, List[str]] = Field(..., title="Errors")
    existing: Dict[str, List[str]] = Field(..., title="Existing")
    to_create: Dict[str, List[str]] = Field(..., title="To Create")


class OrgCreating(BaseModel):
    name: str = Field(..., title="Name")


class OrgDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class OrgReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")


class OrgReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")


class OrgUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")


class PackageCreating(BaseModel):
    name: str = Field(..., title="Name")
    filename: str = Field(..., title="Filename")
    broker_id: UUID = Field(..., title="Broker Id")
    version: str = Field(..., title="Version")
    environment: str = Field(..., title="Environment")
    meta: Optional[Dict[str, Any]] = Field({}, title="Meta")


class PackageDeleting(BaseModel):
    id: UUID = Field(..., title="Id")
    force: Optional[bool] = Field(False, title="Force")


class PackageListingLatest(BaseModel):
    org_id: Optional[UUID] = Field(None, title="Org Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class PackageReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    filename: Optional[str] = Field(None, title="Filename")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")
    version: Optional[str] = Field(None, title="Version")


class PackageReadingLatest(BaseModel):
    name: str = Field(..., title="Name")
    broker_id: UUID = Field(..., title="Broker Id")


class PackageReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    filename: str = Field(..., title="Filename")
    name: str = Field(..., title="Name")
    version: str = Field(..., title="Version")
    meta: Dict[str, Any] = Field(..., title="Meta")
    environment: str = Field(..., title="Environment")
    tasks_using: Optional[int] = Field(None, title="Tasks Using")
    actions_using: Optional[int] = Field(None, title="Actions Using")


class PackageSummary(BaseModel):
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    version: str = Field(..., title="Version")


class PackageUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    meta: Optional[Dict[str, Any]] = Field(None, title="Meta")


class PageAssetReturning(BaseModel):
    items: List[AssetReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageBrokerPathReturning(BaseModel):
    items: List[BrokerPathReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageBrokerReturning(BaseModel):
    items: List[BrokerReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageDatasetReturning(BaseModel):
    items: List[DatasetReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageInvitationReturning(BaseModel):
    items: List[InvitationReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageNotificationReturning(BaseModel):
    items: List[NotificationReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageOrgReturning(BaseModel):
    items: List[OrgReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PagePackageReturning(BaseModel):
    items: List[PackageReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PersonCreating(BaseModel):
    name: str = Field(..., title="Name")
    source: str = Field(..., title="Source")
    email: EmailStr = Field(..., title="Email")
    picture: str = Field(..., title="Picture")
    locale: str = Field(..., title="Locale")
    avatar_url: str = Field(..., title="Avatar Url")
    preferences: Dict[str, Any] = Field(..., title="Preferences")


class PersonDeleting(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    email: Optional[str] = Field(None, title="Email")


class PersonReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    source: Optional[str] = Field(None, title="Source")
    email: Optional[str] = Field(None, title="Email")
    verified: Optional[bool] = Field(None, title="Verified")


class PersonReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    source: str = Field(..., title="Source")
    email: str = Field(..., title="Email")
    picture: str = Field(..., title="Picture")
    avatar_url: str = Field(..., title="Avatar Url")
    locale: str = Field(..., title="Locale")
    verified: bool = Field(..., title="Verified")
    preferences: Dict[str, Any] = Field(..., title="Preferences")


class PersonUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    source: Optional[str] = Field(None, title="Source")
    email: Optional[str] = Field(None, title="Email")
    picture: Optional[str] = Field(None, title="Picture")
    avatar_url: Optional[str] = Field(None, title="Avatar Url")
    locale: Optional[str] = Field(None, title="Locale")
    preferences: Optional[Dict[str, Any]] = Field(None, title="Preferences")
    verified: Optional[bool] = Field(None, title="Verified")
    last_push_time: Optional[datetime] = Field(None, title="Last Push Time")


class ProjectCreating(BaseModel):
    name: str = Field(..., min_length=3, title="Name")
    description: str = Field(..., title="Description")


class ProjectDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class ProjectReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    org_id: Optional[UUID] = Field(None, title="Org Id")


class ProjectReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    name: str = Field(..., title="Name")
    description: str = Field(..., title="Description")


class ProjectStats(BaseModel):
    annotations: int = Field(..., title="Annotations")
    annotators: int = Field(..., title="Annotators")
    live_sessions: int = Field(..., title="Live Sessions")
    tasks_count: int = Field(..., title="Tasks Count")
    actions_count: int = Field(..., title="Actions Count")


class ProjectUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    description: Optional[str] = Field(None, title="Description")


class RecipeDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class RecipeListingLatest(BaseModel):
    org_id: Optional[UUID] = Field(None, title="Org Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class RecipePlanCreating(BaseModel):
    recipe_id: UUID = Field(..., title="Recipe Id")
    project_id: UUID = Field(..., title="Project Id")
    args: Dict[str, Any] = Field(..., title="Args")


class RecipePlanDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class RecipePlanReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    recipe_id: Optional[UUID] = Field(None, title="Recipe Id")
    project_id: Optional[UUID] = Field(None, title="Project Id")


class RecipePlanReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    recipe_id: UUID = Field(..., title="Recipe Id")
    project_id: UUID = Field(..., title="Project Id")
    environment: str = Field(..., title="Environment")
    recipe_name: str = Field(..., title="Recipe Name")
    args: Dict[str, Any] = Field(..., title="Args")
    command: List[str] = Field(..., title="Command")
    objects: Dict[str, Dict[str, Dict[str, Any]]] = Field(..., title="Objects")


class RecipePlanUpdating(BaseModel):
    id: UUID = Field(..., title="Id")


class RecipeReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    name: Optional[str] = Field(None, title="Name")
    package_id: Optional[UUID] = Field(None, title="Package Id")


class RecipeReadingLatest(BaseModel):
    name: str = Field(..., title="Name")
    broker_id: UUID = Field(..., title="Broker Id")


class RecipeReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    package_id: UUID = Field(..., title="Package Id")
    name: str = Field(..., title="Name")
    title: str = Field(..., title="Title")
    description: str = Field(..., title="Description")
    is_action: bool = Field(..., title="Is Action")
    entry_point: str = Field(..., title="Entry Point")
    meta: Dict[str, Any] = Field(..., title="Meta")
    num_used_by: int = Field(..., title="Num Used By")


class RecipeUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    title: str = Field(..., title="Title")


class ReportNomadJobResponse(BaseModel):
    missing: List[UUID] = Field(..., title="Missing")


class SecretCreating(BaseModel):
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")
    broker_id: UUID = Field(..., title="Broker Id")


class SecretDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class SecretDetail(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")
    broker_id: UUID = Field(..., title="Broker Id")


class SecretReading(BaseModel):
    name: Optional[str] = Field(None, title="Name")
    path: Optional[str] = Field(None, title="Path")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class SecretReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")
    broker_id: UUID = Field(..., title="Broker Id")


class SecretUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    path: str = Field(..., title="Path")


class SessionCreating(BaseModel):
    user_id: UUID = Field(..., title="User Id")
    task_id: UUID = Field(..., title="Task Id")


class SessionDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class SessionReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    user_id: Optional[UUID] = Field(None, title="User Id")
    task_id: Optional[UUID] = Field(None, title="Task Id")
    count: Optional[int] = Field(None, title="Count")
    time_spent: Optional[int] = Field(None, title="Time Spent")


class SessionReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    user_id: UUID = Field(..., title="User Id")
    user_name: str = Field(..., title="User Name")
    user_avatar_url: str = Field(..., title="User Avatar Url")
    task_id: UUID = Field(..., title="Task Id")
    count: int = Field(..., title="Count")
    time_spent: int = Field(..., title="Time Spent")


class SessionSaving(BaseModel):
    id: UUID = Field(..., title="Id")
    count: Optional[int] = Field(None, title="Count")
    time_spent: Optional[int] = Field(None, title="Time Spent")


class SessionUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    count: Optional[int] = Field(None, title="Count")


class TaskAnnotator(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    org_name: str = Field(..., title="Org Name")
    person_id: UUID = Field(..., title="Person Id")
    name: str = Field(..., title="Name")
    email: str = Field(..., title="Email")
    avatar_url: str = Field(..., title="Avatar Url")
    locale: str = Field(..., title="Locale")
    groups: List[str] = Field(..., title="Groups")
    tags: List[str] = Field(..., title="Tags")
    is_org_admin: bool = Field(..., title="Is Org Admin")
    is_org_developer: bool = Field(..., title="Is Org Developer")
    live_sessions: int = Field(..., title="Live Sessions")
    annotations: int = Field(..., title="Annotations")
    hours: str = Field(..., title="Hours")


class TaskCreating(BaseModel):
    name: str = Field(..., title="Name")
    project_id: UUID = Field(..., title="Project Id")
    plan: RecipePlanCreating


class TaskDeleting(BaseModel):
    id: UUID = Field(..., title="Id")


class TaskEventDetails(BaseModel):
    fails_task: Optional[bool] = Field(False, title="Fails Task")
    restart_reason: Optional[str] = Field(None, title="Restart Reason")
    setup_error: Optional[str] = Field(None, title="Setup Error")
    driver_error: Optional[str] = Field(None, title="Driver Error")
    exit_code: Optional[int] = Field(None, title="Exit Code")
    signal: Optional[int] = Field(None, title="Signal")
    kill_timeout: Optional[str] = Field(None, title="Kill Timeout")
    kill_error: Optional[str] = Field(None, title="Kill Error")
    kill_reason: Optional[str] = Field(None, title="Kill Reason")
    start_delay: Optional[int] = Field(None, title="Start Delay")
    download_error: Optional[str] = Field(None, title="Download Error")
    validation_error: Optional[str] = Field(None, title="Validation Error")
    disk_limit: Optional[int] = Field(None, title="Disk Limit")
    failed_sibling: Optional[str] = Field(None, title="Failed Sibling")
    vault_error: Optional[str] = Field(None, title="Vault Error")
    task_signal_reason: Optional[str] = Field(None, title="Task Signal Reason")
    task_signal: Optional[str] = Field(None, title="Task Signal")


class TaskEventType(Enum):
    Alloc_Unhealthy = "Alloc Unhealthy"
    Setup_Failure = "Setup Failure"
    Driver_Failure = "Driver Failure"
    Received = "Received"
    Failed_Validation = "Failed Validation"
    Started = "Started"
    Terminated = "Terminated"
    Killing = "Killing"
    Killed = "Killed"
    Restarting = "Restarting"
    Not_Restarting = "Not Restarting"
    Restart_Signaled = "Restart Signaled"
    Signaling = "Signaling"
    Downloading_Artifacts = "Downloading Artifacts"
    Failed_Artifact_Download = "Failed Artifact Download"
    Building_Task_Directory = "Building Task Directory"
    Task_Setup = "Task Setup"
    Disk_Resources_Exceeded = "Disk Resources Exceeded"
    Sibling_Task_Failed = "Sibling Task Failed"
    Driver = "Driver"
    Leader_Task_Dead = "Leader Task Dead"
    Main_Tasks_Dead = "Main Tasks Dead"
    Task_hook_failed = "Task hook failed"
    Task_hook_message = "Task hook message"
    Failed_Restoring_Task = "Failed Restoring Task"
    Plugin_became_unhealthy = "Plugin became unhealthy"
    Plugin_became_healthy = "Plugin became healthy"
    Reconnected = "Reconnected"
    Waiting_for_shutdown_delay = "Waiting for shutdown delay"


class TaskPopulating(BaseModel):
    id: UUID = Field(..., title="Id")
    user_id: UUID = Field(..., title="User Id")


class TaskState(Enum):
    NOT_FOUND = "NOT_FOUND"
    CREATED = "CREATED"
    PREPARING = "PREPARING"
    WITH_PROBLEMS = "WITH_PROBLEMS"
    STARTING = "STARTING"
    STARTED = "STARTED"
    NOT_STARTED = "NOT_STARTED"
    STOPPING = "STOPPING"
    STOPPED = "STOPPED"
    DELETING = "DELETING"
    PENDING = "PENDING"
    FAILED = "FAILED"
    NOMAD_ERROR = "NOMAD_ERROR"
    NOMAD_JOB_ERROR = "NOMAD_JOB_ERROR"
    OBTAINING_MODELS_VENV = "OBTAINING_MODELS_VENV"
    INITIALIZING_VENV = "INITIALIZING_VENV"


class TaskStateReturning(BaseModel):
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    state: TaskState
    is_running: bool = Field(..., title="Is Running")
    is_startable: bool = Field(..., title="Is Startable")
    is_stoppable: bool = Field(..., title="Is Stoppable")


class TaskStats(BaseModel):
    annotations: int = Field(..., title="Annotations")
    annotators: int = Field(..., title="Annotators")
    live_sessions: int = Field(..., title="Live Sessions")


class TaskSummary(BaseModel):
    id: UUID = Field(..., title="Id")
    project_id: UUID = Field(..., title="Project Id")
    name: str = Field(..., title="Name")
    job_type: JobType
    state: TaskState


class TaskUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")


class TypeSchema(BaseModel):
    name: str = Field(..., title="Name")
    args: Optional[List[Union[str, TypeSchema]]] = Field(None, title="Args")
    object_type: Optional[str] = Field(None, title="Object Type")


class UserAuthenticated(BaseModel):
    access_token: str = Field(..., title="Access Token")
    expires_in: int = Field(..., title="Expires In")
    token_type: Optional[str] = Field("bearer", title="Token Type")


class UserCreating(BaseModel):
    org_id: UUID = Field(..., title="Org Id")
    person_id: UUID = Field(..., title="Person Id")
    is_org_admin: bool = Field(..., title="Is Org Admin")
    is_org_developer: bool = Field(..., title="Is Org Developer")
    tags: Optional[List[str]] = Field([], title="Tags")


class UserDeleting(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    person_id: Optional[UUID] = Field(None, title="Person Id")


class UserReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    org_id: Optional[UUID] = Field(None, title="Org Id")
    person_id: Optional[UUID] = Field(None, title="Person Id")
    is_org_admin: Optional[bool] = Field(None, title="Is Org Admin")
    is_org_developer: Optional[bool] = Field(None, title="Is Org Developer")


class UserReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    org_name: str = Field(..., title="Org Name")
    person_id: UUID = Field(..., title="Person Id")
    name: str = Field(..., title="Name")
    email: str = Field(..., title="Email")
    avatar_url: str = Field(..., title="Avatar Url")
    locale: str = Field(..., title="Locale")
    groups: List[str] = Field(..., title="Groups")
    tags: List[str] = Field(..., title="Tags")
    is_org_admin: bool = Field(..., title="Is Org Admin")
    is_org_developer: bool = Field(..., title="Is Org Developer")


class UserUpdating(BaseModel):
    id: UUID = Field(..., title="Id")
    name: Optional[str] = Field(None, title="Name")
    email: Optional[str] = Field(None, title="Email")
    avatar_url: Optional[str] = Field(None, title="Avatar Url")
    locale: Optional[str] = Field(None, title="Locale")
    tags: Optional[List[str]] = Field([], title="Tags")


class ValidationError(BaseModel):
    loc: List[Union[str, int]] = Field(..., title="Location")
    msg: str = Field(..., title="Message")
    type: str = Field(..., title="Error Type")


class ValidationLevel(Enum):
    error = "error"
    warning = "warning"
    info = "info"
    success = "success"


class ValidationOp(Enum):
    ge = "ge"
    gt = "gt"
    le = "le"
    lt = "lt"
    eq = "eq"
    ne = "ne"
    re = "re"


class ValidationSchema(BaseModel):
    op: ValidationOp
    value: Union[int, float, str, bool] = Field(..., title="Value")
    message: str = Field(..., title="Message")
    level: ValidationLevel


class ActionCreating(BaseModel):
    project_id: UUID = Field(..., title="Project Id")
    name: str = Field(..., title="Name")
    evaluation: str = Field(..., title="Evaluation")
    plan: RecipePlanCreating


class ActionExecution(BaseModel):
    id: UUID = Field(..., title="Id")
    is_running: bool = Field(..., title="Is Running")
    started: datetime = Field(..., title="Started")
    runtime: Optional[float] = Field(None, title="Runtime")
    state: ActionState


class ActionReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    state: Optional[ActionState] = None
    project_id: Optional[UUID] = Field(None, title="Project Id")
    broker_id: Optional[UUID] = Field(None, title="Broker Id")


class ActionReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    project_id: UUID = Field(..., title="Project Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    recipe_name: str = Field(..., title="Recipe Name")
    recipe_title: str = Field(..., title="Recipe Title")
    state: ActionState
    evaluation: str = Field(..., title="Evaluation")
    project_name: str = Field(..., title="Project Name")
    is_running: bool = Field(..., title="Is Running")
    is_startable: bool = Field(..., title="Is Startable")
    is_stoppable: bool = Field(..., title="Is Stoppable")
    error: Optional[str] = Field(None, title="Error")
    plan: RecipePlanReturning
    executions: List[ActionExecution] = Field(..., title="Executions")
    last_execution_id: Optional[UUID] = Field(None, title="Last Execution Id")
    nomad_index: int = Field(..., title="Nomad Index")
    stats: ActionStats
    cli_command: str = Field(..., title="Cli Command")
    url_logs: str = Field(..., title="Url Logs")
    url: str = Field(..., title="Url")
    related_tasks: List[UUID] = Field(..., title="Related Tasks")


class ActionSummary(BaseModel):
    id: UUID = Field(..., title="Id")
    project_id: UUID = Field(..., title="Project Id")
    name: str = Field(..., title="Name")
    job_type: JobType
    state: ActionState


class AssetDetail(BaseModel):
    created: Optional[datetime] = Field(None, title="Created")
    updated: Optional[datetime] = Field(None, title="Updated")
    id: UUID = Field(..., title="Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    kind: str = Field(..., title="Kind")
    path: str = Field(..., title="Path")
    meta: Dict[str, Any] = Field(..., title="Meta")
    tasks: List[TaskSummary] = Field(..., title="Tasks")
    actions: List[ActionSummary] = Field(..., title="Actions")


class ClusterJobReading(BaseModel):
    job_id: UUID = Field(..., title="Job Id")
    user_id: UUID = Field(..., title="User Id")
    job_type: JobType


class ClusterJobReturning(BaseModel):
    job_id: UUID = Field(..., title="Job Id")
    execution_id: Optional[UUID] = Field(None, title="Execution Id")
    attempt_id: UUID = Field(..., title="Attempt Id")
    job_type: JobType
    name: str = Field(..., title="Name")
    plan: RecipePlanReturning


class DatasetDetail(BaseModel):
    created: Optional[datetime] = Field(None, title="Created")
    updated: Optional[datetime] = Field(None, title="Updated")
    id: UUID = Field(..., title="Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    kind: str = Field(..., title="Kind")
    tasks: List[TaskSummary] = Field(..., title="Tasks")
    actions: List[ActionSummary] = Field(..., title="Actions")


class GroupReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    name: str = Field(..., title="Name")
    org_id: UUID = Field(..., title="Org Id")
    users: List[UserReturning] = Field(..., title="Users")


class HTTPValidationError(BaseModel):
    detail: Optional[List[ValidationError]] = Field(None, title="Detail")


class NomadEventBatchCreating(BaseModel):
    index: int = Field(..., title="Index")
    broker_id: UUID = Field(..., title="Broker Id")
    events: List[NomadEventCreating] = Field(..., title="Events")


class NomadTaskEvent(BaseModel):
    Type: TaskEventType
    Time: int = Field(..., title="Time")
    Message: str = Field(..., title="Message")
    DisplayMessage: str = Field(..., title="Displaymessage")
    Details: TaskEventDetails
    FailsTask: bool = Field(..., title="Failstask")
    RestartReason: str = Field(..., title="Restartreason")
    SetupError: str = Field(..., title="Setuperror")
    DriverError: str = Field(..., title="Drivererror")
    ExitCode: int = Field(..., title="Exitcode")
    Signal: int = Field(..., title="Signal")
    KillTimeout: int = Field(..., title="Killtimeout")
    KillError: str = Field(..., title="Killerror")
    KillReason: str = Field(..., title="Killreason")
    StartDelay: int = Field(..., title="Startdelay")
    DownloadError: str = Field(..., title="Downloaderror")
    ValidationError: str = Field(..., title="Validationerror")
    DiskLimit: int = Field(..., title="Disklimit")
    FailedSibling: str = Field(..., title="Failedsibling")
    VaultError: str = Field(..., title="Vaulterror")
    TaskSignalReason: str = Field(..., title="Tasksignalreason")
    TaskSignal: str = Field(..., title="Tasksignal")
    DriverMessage: str = Field(..., title="Drivermessage")
    GenericSource: str = Field(..., title="Genericsource")


class NomadTaskState(BaseModel):
    State: str = Field(..., title="State")
    Failed: bool = Field(..., title="Failed")
    Restarts: int = Field(..., title="Restarts")
    LastRestart: Optional[int] = Field(None, title="Lastrestart")
    StartedAt: Optional[datetime] = Field(None, title="Startedat")
    FinishedAt: Optional[datetime] = Field(None, title="Finishedat")
    Events: List[NomadTaskEvent] = Field(..., title="Events")


class PageActionReturning(BaseModel):
    items: List[ActionReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageGroupReturning(BaseModel):
    items: List[GroupReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PagePersonReturning(BaseModel):
    items: List[PersonReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageProjectReturning(BaseModel):
    items: List[ProjectReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageRecipePlanReturning(BaseModel):
    items: List[RecipePlanReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageRecipeReturning(BaseModel):
    items: List[RecipeReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageSecretReturning(BaseModel):
    items: List[SecretReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageSessionReturning(BaseModel):
    items: List[SessionReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageTaskAnnotator(BaseModel):
    items: List[TaskAnnotator] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class PageUserReturning(BaseModel):
    items: List[UserReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class Props(BaseModel):
    name: Optional[str] = Field(None, title="Name")
    title: Optional[str] = Field(None, title="Title")
    description: Optional[str] = Field(None, title="Description")
    placeholder: Optional[str] = Field(None, title="Placeholder")
    value: Optional[Any] = Field(None, title="Value")
    required: Optional[bool] = Field(None, title="Required")
    positional: Optional[bool] = Field(None, title="Positional")
    exists: Optional[bool] = Field(None, title="Exists")
    validations: Optional[List[ValidationSchema]] = Field(None, title="Validations")
    pattern: Optional[str] = Field(None, title="Pattern")
    widget: Optional[str] = Field(None, title="Widget")
    choice: Optional[Dict[str, Props]] = Field(None, title="Choice")
    min: Optional[float] = Field(None, title="Min")
    max: Optional[float] = Field(None, title="Max")
    step: Optional[float] = Field(None, title="Step")
    optional_title: Optional[str] = Field(None, title="Optional Title")


class TaskReading(BaseModel):
    id: Optional[UUID] = Field(None, title="Id")
    name: Optional[str] = Field(None, title="Name")
    state: Optional[TaskState] = None
    project_id: Optional[UUID] = Field(None, title="Project Id")


class TaskReturning(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    project_id: UUID = Field(..., title="Project Id")
    broker_id: UUID = Field(..., title="Broker Id")
    name: str = Field(..., title="Name")
    recipe_name: str = Field(..., title="Recipe Name")
    recipe_title: str = Field(..., title="Recipe Title")
    state: TaskState
    project_name: str = Field(..., title="Project Name")
    is_running: bool = Field(..., title="Is Running")
    is_startable: bool = Field(..., title="Is Startable")
    is_stoppable: bool = Field(..., title="Is Stoppable")
    error: Optional[str] = Field(None, title="Error")
    plan: RecipePlanReturning
    nomad_index: int = Field(..., title="Nomad Index")
    last_execution_id: Optional[UUID] = Field(None, title="Last Execution Id")
    related_actions: List[UUID] = Field(..., title="Related Actions")
    cli_command: str = Field(..., title="Cli Command")
    url_logs: str = Field(..., title="Url Logs")
    url: str = Field(..., title="Url")


class FieldSchema(BaseModel):
    name: str = Field(..., title="Name")
    type: TypeSchema
    props: Props
    fields: Optional[List[FieldSchema]] = Field([], title="Fields")
    choice: Optional[List[FieldSchema]] = Field([], title="Choice")


class NomadAllocationStub(BaseModel):
    ID: UUID = Field(..., title="Id")
    EvalID: UUID = Field(..., title="Evalid")
    Name: str = Field(..., title="Name")
    Namespace: str = Field(..., title="Namespace")
    NodeID: UUID = Field(..., title="Nodeid")
    NodeName: str = Field(..., title="Nodename")
    JobID: UUID = Field(..., title="Jobid")
    JobType: Optional[str] = Field(None, title="Jobtype")
    JobVersion: Optional[int] = Field(None, title="Jobversion")
    TaskGroup: str = Field(..., title="Taskgroup")
    DesiredStatus: AllocDesiredStatus
    DesiredDescription: Optional[str] = Field(None, title="Desireddescription")
    ClientStatus: AllocClientStatus
    ClientDescription: Optional[str] = Field(None, title="Clientdescription")
    TaskStates: Optional[Dict[str, NomadTaskState]] = Field({}, title="Taskstates")
    FollowupEvalID: Optional[UUID] = Field(None, title="Followupevalid")
    PreemptedAllocations: Optional[List[str]] = Field(
        None, title="Preemptedallocations"
    )
    PreemptedByAllocation: Optional[UUID] = Field(None, title="Preemptedbyallocation")
    CreateIndex: int = Field(..., title="Createindex")
    ModifyIndex: int = Field(..., title="Modifyindex")
    CreateTime: int = Field(..., title="Createtime")
    ModifyTime: int = Field(..., title="Modifytime")


class PageTaskReturning(BaseModel):
    items: List[TaskReturning] = Field(..., title="Items")
    total: int = Field(..., ge=0, title="Total")
    page: int = Field(..., ge=1, title="Page")
    size: int = Field(..., ge=1, title="Size")


class RecipeSchema(BaseModel):
    name: str = Field(..., title="Name")
    fields: List[FieldSchema] = Field(..., title="Fields")
    title: Optional[str] = Field(None, title="Title")
    description: Optional[str] = Field(None, title="Description")
    view_id: Optional[str] = Field(None, title="View Id")
    cli_names: Optional[Dict[str, str]] = Field(None, title="Cli Names")


class NomadJobs(BaseModel):
    jobs: List[NomadJobStub] = Field(..., title="Jobs")
    allocations: List[NomadAllocationStub] = Field(..., title="Allocations")


class RecipeCreating(BaseModel):
    name: str = Field(..., title="Name")
    title: str = Field(..., title="Title")
    description: str = Field(..., title="Description")
    is_action: bool = Field(..., title="Is Action")
    entry_point: str = Field(..., title="Entry Point")
    form_schema: RecipeSchema
    cli_schema: Dict[str, Any] = Field(..., title="Cli Schema")
    meta: Dict[str, Any] = Field(..., title="Meta")
    package_id: UUID = Field(..., title="Package Id")


class RecipeDetail(BaseModel):
    created: datetime = Field(..., title="Created")
    updated: datetime = Field(..., title="Updated")
    id: UUID = Field(..., title="Id")
    org_id: UUID = Field(..., title="Org Id")
    package_id: UUID = Field(..., title="Package Id")
    name: str = Field(..., title="Name")
    title: str = Field(..., title="Title")
    description: str = Field(..., title="Description")
    is_action: bool = Field(..., title="Is Action")
    entry_point: str = Field(..., title="Entry Point")
    form_schema: RecipeSchema
    cli_schema: Dict[str, Any] = Field(..., title="Cli Schema")
    meta: Dict[str, Any] = Field(..., title="Meta")
    tasks: List[TaskSummary] = Field(..., title="Tasks")
    actions: List[ActionSummary] = Field(..., title="Actions")
    package: Optional[PackageSummary] = None
    num_used_by: int = Field(..., title="Num Used By")


CackQuerying.update_forward_refs()
TypeSchema.update_forward_refs()
Props.update_forward_refs()
FieldSchema.update_forward_refs()
