"""add reason, input_params to pipeline runs

Revision ID: c2a3cb9f639e
Revises: cd90ef97cbc9
Create Date: 2025-10-27 00:37:45.655304

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa

from plombery.database.type_helpers import PydanticType


# revision identifiers, used by Alembic.
revision: str = "c2a3cb9f639e"
down_revision: Union[str, Sequence[str], None] = "cd90ef97cbc9"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "pipeline_runs", sa.Column("input_params", PydanticType(dict), nullable=True)
    )
    op.add_column("pipeline_runs", sa.Column("reason", sa.String(), nullable=True))
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("pipeline_runs", "reason")
    op.drop_column("pipeline_runs", "input_params")
    # ### end Alembic commands ###
