"""initial db setup

Revision ID: cd90ef97cbc9
Revises:
Create Date: 2025-10-26 20:23:36.777395

"""

from typing import List, Sequence, Union

from alembic import op
import sqlalchemy as sa
from plombery.database.type_helpers import AwareDateTime, PydanticType
from plombery.schemas import TaskRun


# revision identifiers, used by Alembic.
revision: str = "cd90ef97cbc9"
down_revision: Union[str, Sequence[str], None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pipeline_runs",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("pipeline_id", sa.String(), nullable=True),
        sa.Column("trigger_id", sa.String(), nullable=True),
        sa.Column("status", sa.String(), nullable=True),
        sa.Column("start_time", AwareDateTime(), nullable=True),
        sa.Column("duration", sa.Integer(), nullable=True),
        sa.Column("tasks_run", PydanticType(List[TaskRun]), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_pipeline_runs_id"), "pipeline_runs", ["id"], unique=False)
    op.create_index(
        op.f("ix_pipeline_runs_pipeline_id"),
        "pipeline_runs",
        ["pipeline_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_pipeline_runs_pipeline_id"), table_name="pipeline_runs")
    op.drop_index(op.f("ix_pipeline_runs_id"), table_name="pipeline_runs")
    op.drop_table("pipeline_runs")
    # ### end Alembic commands ###
