# ory-client
# Introduction
Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed
with a valid Personal Access Token. Public APIs are mostly used in browsers.

## SDKs
This document describes the APIs available in the Ory Network. The APIs are available as SDKs for the following languages:

| Language       | Download SDK                                                     | Documentation                                                                        |
| -------------- | ---------------------------------------------------------------- | ------------------------------------------------------------------------------------ |
| Dart           | [pub.dev](https://pub.dev/packages/ory_client)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/dart/README.md)       |
| .NET           | [nuget.org](https://www.nuget.org/packages/Ory.Client/)          | [README](https://github.com/ory/sdk/blob/master/clients/client/dotnet/README.md)     |
| Elixir         | [hex.pm](https://hex.pm/packages/ory_client)                     | [README](https://github.com/ory/sdk/blob/master/clients/client/elixir/README.md)     |
| Go             | [github.com](https://github.com/ory/client-go)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/go/README.md)         |
| Java           | [maven.org](https://search.maven.org/artifact/sh.ory/ory-client) | [README](https://github.com/ory/sdk/blob/master/clients/client/java/README.md)       |
| JavaScript     | [npmjs.com](https://www.npmjs.com/package/@ory/client)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript/README.md) |
| JavaScript (With fetch) | [npmjs.com](https://www.npmjs.com/package/@ory/client-fetch)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript-fetch/README.md) | 
| PHP            | [packagist.org](https://packagist.org/packages/ory/client)       | [README](https://github.com/ory/sdk/blob/master/clients/client/php/README.md)        |
| Python         | [pypi.org](https://pypi.org/project/ory-client/)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/python/README.md)     |
| Ruby           | [rubygems.org](https://rubygems.org/gems/ory-client)             | [README](https://github.com/ory/sdk/blob/master/clients/client/ruby/README.md)       |
| Rust           | [crates.io](https://crates.io/crates/ory-client)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/rust/README.md)       |


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1.22.4
- Package version: v1.22.4
- Generator version: 7.12.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import ory_client
from ory_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://playground.projects.oryapis.com
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_client.Configuration(
    host = "https://playground.projects.oryapis.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: oryAccessToken
configuration = ory_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with ory_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = ory_client.CourierApi(api_client)
    id = 'id_example' # str | MessageID is the ID of the message.

    try:
        # Get a Message
        api_response = api_instance.get_courier_message(id)
        print("The response of CourierApi->get_courier_message:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CourierApi->get_courier_message: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://playground.projects.oryapis.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CourierApi* | [**get_courier_message**](docs/CourierApi.md#get_courier_message) | **GET** /admin/courier/messages/{id} | Get a Message
*CourierApi* | [**list_courier_messages**](docs/CourierApi.md#list_courier_messages) | **GET** /admin/courier/messages | List Messages
*EventsApi* | [**create_event_stream**](docs/EventsApi.md#create_event_stream) | **POST** /projects/{project_id}/eventstreams | Create an event stream for your project.
*EventsApi* | [**delete_event_stream**](docs/EventsApi.md#delete_event_stream) | **DELETE** /projects/{project_id}/eventstreams/{event_stream_id} | Remove an event stream from a project
*EventsApi* | [**list_event_streams**](docs/EventsApi.md#list_event_streams) | **GET** /projects/{project_id}/eventstreams | List all event streams for the project. This endpoint is not paginated.
*EventsApi* | [**set_event_stream**](docs/EventsApi.md#set_event_stream) | **PUT** /projects/{project_id}/eventstreams/{event_stream_id} | Update an event stream for a project.
*FrontendApi* | [**create_browser_login_flow**](docs/FrontendApi.md#create_browser_login_flow) | **GET** /self-service/login/browser | Create Login Flow for Browsers
*FrontendApi* | [**create_browser_logout_flow**](docs/FrontendApi.md#create_browser_logout_flow) | **GET** /self-service/logout/browser | Create a Logout URL for Browsers
*FrontendApi* | [**create_browser_recovery_flow**](docs/FrontendApi.md#create_browser_recovery_flow) | **GET** /self-service/recovery/browser | Create Recovery Flow for Browsers
*FrontendApi* | [**create_browser_registration_flow**](docs/FrontendApi.md#create_browser_registration_flow) | **GET** /self-service/registration/browser | Create Registration Flow for Browsers
*FrontendApi* | [**create_browser_settings_flow**](docs/FrontendApi.md#create_browser_settings_flow) | **GET** /self-service/settings/browser | Create Settings Flow for Browsers
*FrontendApi* | [**create_browser_verification_flow**](docs/FrontendApi.md#create_browser_verification_flow) | **GET** /self-service/verification/browser | Create Verification Flow for Browser Clients
*FrontendApi* | [**create_fedcm_flow**](docs/FrontendApi.md#create_fedcm_flow) | **GET** /self-service/fed-cm/parameters | Get FedCM Parameters
*FrontendApi* | [**create_native_login_flow**](docs/FrontendApi.md#create_native_login_flow) | **GET** /self-service/login/api | Create Login Flow for Native Apps
*FrontendApi* | [**create_native_recovery_flow**](docs/FrontendApi.md#create_native_recovery_flow) | **GET** /self-service/recovery/api | Create Recovery Flow for Native Apps
*FrontendApi* | [**create_native_registration_flow**](docs/FrontendApi.md#create_native_registration_flow) | **GET** /self-service/registration/api | Create Registration Flow for Native Apps
*FrontendApi* | [**create_native_settings_flow**](docs/FrontendApi.md#create_native_settings_flow) | **GET** /self-service/settings/api | Create Settings Flow for Native Apps
*FrontendApi* | [**create_native_verification_flow**](docs/FrontendApi.md#create_native_verification_flow) | **GET** /self-service/verification/api | Create Verification Flow for Native Apps
*FrontendApi* | [**disable_my_other_sessions**](docs/FrontendApi.md#disable_my_other_sessions) | **DELETE** /sessions | Disable my other sessions
*FrontendApi* | [**disable_my_session**](docs/FrontendApi.md#disable_my_session) | **DELETE** /sessions/{id} | Disable one of my sessions
*FrontendApi* | [**exchange_session_token**](docs/FrontendApi.md#exchange_session_token) | **GET** /sessions/token-exchange | Exchange Session Token
*FrontendApi* | [**get_flow_error**](docs/FrontendApi.md#get_flow_error) | **GET** /self-service/errors | Get User-Flow Errors
*FrontendApi* | [**get_login_flow**](docs/FrontendApi.md#get_login_flow) | **GET** /self-service/login/flows | Get Login Flow
*FrontendApi* | [**get_recovery_flow**](docs/FrontendApi.md#get_recovery_flow) | **GET** /self-service/recovery/flows | Get Recovery Flow
*FrontendApi* | [**get_registration_flow**](docs/FrontendApi.md#get_registration_flow) | **GET** /self-service/registration/flows | Get Registration Flow
*FrontendApi* | [**get_settings_flow**](docs/FrontendApi.md#get_settings_flow) | **GET** /self-service/settings/flows | Get Settings Flow
*FrontendApi* | [**get_verification_flow**](docs/FrontendApi.md#get_verification_flow) | **GET** /self-service/verification/flows | Get Verification Flow
*FrontendApi* | [**get_web_authn_java_script**](docs/FrontendApi.md#get_web_authn_java_script) | **GET** /.well-known/ory/webauthn.js | Get WebAuthn JavaScript
*FrontendApi* | [**list_my_sessions**](docs/FrontendApi.md#list_my_sessions) | **GET** /sessions | Get My Active Sessions
*FrontendApi* | [**perform_native_logout**](docs/FrontendApi.md#perform_native_logout) | **DELETE** /self-service/logout/api | Perform Logout for Native Apps
*FrontendApi* | [**to_session**](docs/FrontendApi.md#to_session) | **GET** /sessions/whoami | Check Who the Current HTTP Session Belongs To
*FrontendApi* | [**update_fedcm_flow**](docs/FrontendApi.md#update_fedcm_flow) | **POST** /self-service/fed-cm/token | Submit a FedCM token
*FrontendApi* | [**update_login_flow**](docs/FrontendApi.md#update_login_flow) | **POST** /self-service/login | Submit a Login Flow
*FrontendApi* | [**update_logout_flow**](docs/FrontendApi.md#update_logout_flow) | **GET** /self-service/logout | Update Logout Flow
*FrontendApi* | [**update_recovery_flow**](docs/FrontendApi.md#update_recovery_flow) | **POST** /self-service/recovery | Update Recovery Flow
*FrontendApi* | [**update_registration_flow**](docs/FrontendApi.md#update_registration_flow) | **POST** /self-service/registration | Update Registration Flow
*FrontendApi* | [**update_settings_flow**](docs/FrontendApi.md#update_settings_flow) | **POST** /self-service/settings | Complete Settings Flow
*FrontendApi* | [**update_verification_flow**](docs/FrontendApi.md#update_verification_flow) | **POST** /self-service/verification | Complete Verification Flow
*IdentityApi* | [**batch_patch_identities**](docs/IdentityApi.md#batch_patch_identities) | **PATCH** /admin/identities | Create multiple identities
*IdentityApi* | [**create_identity**](docs/IdentityApi.md#create_identity) | **POST** /admin/identities | Create an Identity
*IdentityApi* | [**create_recovery_code_for_identity**](docs/IdentityApi.md#create_recovery_code_for_identity) | **POST** /admin/recovery/code | Create a Recovery Code
*IdentityApi* | [**create_recovery_link_for_identity**](docs/IdentityApi.md#create_recovery_link_for_identity) | **POST** /admin/recovery/link | Create a Recovery Link
*IdentityApi* | [**delete_identity**](docs/IdentityApi.md#delete_identity) | **DELETE** /admin/identities/{id} | Delete an Identity
*IdentityApi* | [**delete_identity_credentials**](docs/IdentityApi.md#delete_identity_credentials) | **DELETE** /admin/identities/{id}/credentials/{type} | Delete a credential for a specific identity
*IdentityApi* | [**delete_identity_sessions**](docs/IdentityApi.md#delete_identity_sessions) | **DELETE** /admin/identities/{id}/sessions | Delete &amp; Invalidate an Identity&#39;s Sessions
*IdentityApi* | [**disable_session**](docs/IdentityApi.md#disable_session) | **DELETE** /admin/sessions/{id} | Deactivate a Session
*IdentityApi* | [**extend_session**](docs/IdentityApi.md#extend_session) | **PATCH** /admin/sessions/{id}/extend | Extend a Session
*IdentityApi* | [**get_identity**](docs/IdentityApi.md#get_identity) | **GET** /admin/identities/{id} | Get an Identity
*IdentityApi* | [**get_identity_by_external_id**](docs/IdentityApi.md#get_identity_by_external_id) | **GET** /admin/identities/by/external/{externalID} | Get an Identity by its External ID
*IdentityApi* | [**get_identity_schema**](docs/IdentityApi.md#get_identity_schema) | **GET** /schemas/{id} | Get Identity JSON Schema
*IdentityApi* | [**get_session**](docs/IdentityApi.md#get_session) | **GET** /admin/sessions/{id} | Get Session
*IdentityApi* | [**list_identities**](docs/IdentityApi.md#list_identities) | **GET** /admin/identities | List Identities
*IdentityApi* | [**list_identity_schemas**](docs/IdentityApi.md#list_identity_schemas) | **GET** /schemas | Get all Identity Schemas
*IdentityApi* | [**list_identity_sessions**](docs/IdentityApi.md#list_identity_sessions) | **GET** /admin/identities/{id}/sessions | List an Identity&#39;s Sessions
*IdentityApi* | [**list_sessions**](docs/IdentityApi.md#list_sessions) | **GET** /admin/sessions | List All Sessions
*IdentityApi* | [**patch_identity**](docs/IdentityApi.md#patch_identity) | **PATCH** /admin/identities/{id} | Patch an Identity
*IdentityApi* | [**update_identity**](docs/IdentityApi.md#update_identity) | **PUT** /admin/identities/{id} | Update an Identity
*JwkApi* | [**create_json_web_key_set**](docs/JwkApi.md#create_json_web_key_set) | **POST** /admin/keys/{set} | Create JSON Web Key
*JwkApi* | [**delete_json_web_key**](docs/JwkApi.md#delete_json_web_key) | **DELETE** /admin/keys/{set}/{kid} | Delete JSON Web Key
*JwkApi* | [**delete_json_web_key_set**](docs/JwkApi.md#delete_json_web_key_set) | **DELETE** /admin/keys/{set} | Delete JSON Web Key Set
*JwkApi* | [**get_json_web_key**](docs/JwkApi.md#get_json_web_key) | **GET** /admin/keys/{set}/{kid} | Get JSON Web Key
*JwkApi* | [**get_json_web_key_set**](docs/JwkApi.md#get_json_web_key_set) | **GET** /admin/keys/{set} | Retrieve a JSON Web Key Set
*JwkApi* | [**set_json_web_key**](docs/JwkApi.md#set_json_web_key) | **PUT** /admin/keys/{set}/{kid} | Set JSON Web Key
*JwkApi* | [**set_json_web_key_set**](docs/JwkApi.md#set_json_web_key_set) | **PUT** /admin/keys/{set} | Update a JSON Web Key Set
*MetadataApi* | [**get_version**](docs/MetadataApi.md#get_version) | **GET** /version | Return Running Software Version.
*OAuth2Api* | [**accept_o_auth2_consent_request**](docs/OAuth2Api.md#accept_o_auth2_consent_request) | **PUT** /admin/oauth2/auth/requests/consent/accept | Accept OAuth 2.0 Consent Request
*OAuth2Api* | [**accept_o_auth2_login_request**](docs/OAuth2Api.md#accept_o_auth2_login_request) | **PUT** /admin/oauth2/auth/requests/login/accept | Accept OAuth 2.0 Login Request
*OAuth2Api* | [**accept_o_auth2_logout_request**](docs/OAuth2Api.md#accept_o_auth2_logout_request) | **PUT** /admin/oauth2/auth/requests/logout/accept | Accept OAuth 2.0 Session Logout Request
*OAuth2Api* | [**accept_user_code_request**](docs/OAuth2Api.md#accept_user_code_request) | **PUT** /admin/oauth2/auth/requests/device/accept | Accepts a device grant user_code request
*OAuth2Api* | [**create_o_auth2_client**](docs/OAuth2Api.md#create_o_auth2_client) | **POST** /admin/clients | Create OAuth 2.0 Client
*OAuth2Api* | [**delete_o_auth2_client**](docs/OAuth2Api.md#delete_o_auth2_client) | **DELETE** /admin/clients/{id} | Delete OAuth 2.0 Client
*OAuth2Api* | [**delete_o_auth2_token**](docs/OAuth2Api.md#delete_o_auth2_token) | **DELETE** /admin/oauth2/tokens | Delete OAuth 2.0 Access Tokens from specific OAuth 2.0 Client
*OAuth2Api* | [**delete_trusted_o_auth2_jwt_grant_issuer**](docs/OAuth2Api.md#delete_trusted_o_auth2_jwt_grant_issuer) | **DELETE** /admin/trust/grants/jwt-bearer/issuers/{id} | Delete Trusted OAuth2 JWT Bearer Grant Type Issuer
*OAuth2Api* | [**get_o_auth2_client**](docs/OAuth2Api.md#get_o_auth2_client) | **GET** /admin/clients/{id} | Get an OAuth 2.0 Client
*OAuth2Api* | [**get_o_auth2_consent_request**](docs/OAuth2Api.md#get_o_auth2_consent_request) | **GET** /admin/oauth2/auth/requests/consent | Get OAuth 2.0 Consent Request
*OAuth2Api* | [**get_o_auth2_login_request**](docs/OAuth2Api.md#get_o_auth2_login_request) | **GET** /admin/oauth2/auth/requests/login | Get OAuth 2.0 Login Request
*OAuth2Api* | [**get_o_auth2_logout_request**](docs/OAuth2Api.md#get_o_auth2_logout_request) | **GET** /admin/oauth2/auth/requests/logout | Get OAuth 2.0 Session Logout Request
*OAuth2Api* | [**get_trusted_o_auth2_jwt_grant_issuer**](docs/OAuth2Api.md#get_trusted_o_auth2_jwt_grant_issuer) | **GET** /admin/trust/grants/jwt-bearer/issuers/{id} | Get Trusted OAuth2 JWT Bearer Grant Type Issuer
*OAuth2Api* | [**introspect_o_auth2_token**](docs/OAuth2Api.md#introspect_o_auth2_token) | **POST** /admin/oauth2/introspect | Introspect OAuth2 Access and Refresh Tokens
*OAuth2Api* | [**list_o_auth2_clients**](docs/OAuth2Api.md#list_o_auth2_clients) | **GET** /admin/clients | List OAuth 2.0 Clients
*OAuth2Api* | [**list_o_auth2_consent_sessions**](docs/OAuth2Api.md#list_o_auth2_consent_sessions) | **GET** /admin/oauth2/auth/sessions/consent | List OAuth 2.0 Consent Sessions of a Subject
*OAuth2Api* | [**list_trusted_o_auth2_jwt_grant_issuers**](docs/OAuth2Api.md#list_trusted_o_auth2_jwt_grant_issuers) | **GET** /admin/trust/grants/jwt-bearer/issuers | List Trusted OAuth2 JWT Bearer Grant Type Issuers
*OAuth2Api* | [**o_auth2_authorize**](docs/OAuth2Api.md#o_auth2_authorize) | **GET** /oauth2/auth | OAuth 2.0 Authorize Endpoint
*OAuth2Api* | [**o_auth2_device_flow**](docs/OAuth2Api.md#o_auth2_device_flow) | **POST** /oauth2/device/auth | The OAuth 2.0 Device Authorize Endpoint
*OAuth2Api* | [**oauth2_token_exchange**](docs/OAuth2Api.md#oauth2_token_exchange) | **POST** /oauth2/token | The OAuth 2.0 Token Endpoint
*OAuth2Api* | [**patch_o_auth2_client**](docs/OAuth2Api.md#patch_o_auth2_client) | **PATCH** /admin/clients/{id} | Patch OAuth 2.0 Client
*OAuth2Api* | [**perform_o_auth2_device_verification_flow**](docs/OAuth2Api.md#perform_o_auth2_device_verification_flow) | **GET** /oauth2/device/verify | OAuth 2.0 Device Verification Endpoint
*OAuth2Api* | [**reject_o_auth2_consent_request**](docs/OAuth2Api.md#reject_o_auth2_consent_request) | **PUT** /admin/oauth2/auth/requests/consent/reject | Reject OAuth 2.0 Consent Request
*OAuth2Api* | [**reject_o_auth2_login_request**](docs/OAuth2Api.md#reject_o_auth2_login_request) | **PUT** /admin/oauth2/auth/requests/login/reject | Reject OAuth 2.0 Login Request
*OAuth2Api* | [**reject_o_auth2_logout_request**](docs/OAuth2Api.md#reject_o_auth2_logout_request) | **PUT** /admin/oauth2/auth/requests/logout/reject | Reject OAuth 2.0 Session Logout Request
*OAuth2Api* | [**revoke_o_auth2_consent_sessions**](docs/OAuth2Api.md#revoke_o_auth2_consent_sessions) | **DELETE** /admin/oauth2/auth/sessions/consent | Revoke OAuth 2.0 Consent Sessions of a Subject
*OAuth2Api* | [**revoke_o_auth2_login_sessions**](docs/OAuth2Api.md#revoke_o_auth2_login_sessions) | **DELETE** /admin/oauth2/auth/sessions/login | Revokes OAuth 2.0 Login Sessions by either a Subject or a SessionID
*OAuth2Api* | [**revoke_o_auth2_token**](docs/OAuth2Api.md#revoke_o_auth2_token) | **POST** /oauth2/revoke | Revoke OAuth 2.0 Access or Refresh Token
*OAuth2Api* | [**set_o_auth2_client**](docs/OAuth2Api.md#set_o_auth2_client) | **PUT** /admin/clients/{id} | Set OAuth 2.0 Client
*OAuth2Api* | [**set_o_auth2_client_lifespans**](docs/OAuth2Api.md#set_o_auth2_client_lifespans) | **PUT** /admin/clients/{id}/lifespans | Set OAuth2 Client Token Lifespans
*OAuth2Api* | [**trust_o_auth2_jwt_grant_issuer**](docs/OAuth2Api.md#trust_o_auth2_jwt_grant_issuer) | **POST** /admin/trust/grants/jwt-bearer/issuers | Trust OAuth2 JWT Bearer Grant Type Issuer
*OidcApi* | [**create_oidc_dynamic_client**](docs/OidcApi.md#create_oidc_dynamic_client) | **POST** /oauth2/register | Register OAuth2 Client using OpenID Dynamic Client Registration
*OidcApi* | [**create_verifiable_credential**](docs/OidcApi.md#create_verifiable_credential) | **POST** /credentials | Issues a Verifiable Credential
*OidcApi* | [**delete_oidc_dynamic_client**](docs/OidcApi.md#delete_oidc_dynamic_client) | **DELETE** /oauth2/register/{id} | Delete OAuth 2.0 Client using the OpenID Dynamic Client Registration Management Protocol
*OidcApi* | [**discover_oidc_configuration**](docs/OidcApi.md#discover_oidc_configuration) | **GET** /.well-known/openid-configuration | OpenID Connect Discovery
*OidcApi* | [**get_oidc_dynamic_client**](docs/OidcApi.md#get_oidc_dynamic_client) | **GET** /oauth2/register/{id} | Get OAuth2 Client using OpenID Dynamic Client Registration
*OidcApi* | [**get_oidc_user_info**](docs/OidcApi.md#get_oidc_user_info) | **GET** /userinfo | OpenID Connect Userinfo
*OidcApi* | [**revoke_oidc_session**](docs/OidcApi.md#revoke_oidc_session) | **GET** /oauth2/sessions/logout | OpenID Connect Front- and Back-channel Enabled Logout
*OidcApi* | [**set_oidc_dynamic_client**](docs/OidcApi.md#set_oidc_dynamic_client) | **PUT** /oauth2/register/{id} | Set OAuth2 Client using OpenID Dynamic Client Registration
*PermissionApi* | [**batch_check_permission**](docs/PermissionApi.md#batch_check_permission) | **POST** /relation-tuples/batch/check | Batch check permissions
*PermissionApi* | [**check_permission**](docs/PermissionApi.md#check_permission) | **GET** /relation-tuples/check/openapi | Check a permission
*PermissionApi* | [**check_permission_or_error**](docs/PermissionApi.md#check_permission_or_error) | **GET** /relation-tuples/check | Check a permission
*PermissionApi* | [**expand_permissions**](docs/PermissionApi.md#expand_permissions) | **GET** /relation-tuples/expand | Expand a Relationship into permissions.
*PermissionApi* | [**post_check_permission**](docs/PermissionApi.md#post_check_permission) | **POST** /relation-tuples/check/openapi | Check a permission
*PermissionApi* | [**post_check_permission_or_error**](docs/PermissionApi.md#post_check_permission_or_error) | **POST** /relation-tuples/check | Check a permission
*ProjectApi* | [**create_organization**](docs/ProjectApi.md#create_organization) | **POST** /projects/{project_id}/organizations | Create an Enterprise SSO Organization
*ProjectApi* | [**create_organization_onboarding_portal_link**](docs/ProjectApi.md#create_organization_onboarding_portal_link) | **POST** /projects/{project_id}/organizations/{organization_id}/onboarding-portal-links | Create organization onboarding portal link
*ProjectApi* | [**create_project**](docs/ProjectApi.md#create_project) | **POST** /projects | Create a Project
*ProjectApi* | [**create_project_api_key**](docs/ProjectApi.md#create_project_api_key) | **POST** /projects/{project}/tokens | Create project API key
*ProjectApi* | [**delete_organization**](docs/ProjectApi.md#delete_organization) | **DELETE** /projects/{project_id}/organizations/{organization_id} | Delete Enterprise SSO Organization
*ProjectApi* | [**delete_organization_onboarding_portal_link**](docs/ProjectApi.md#delete_organization_onboarding_portal_link) | **DELETE** /projects/{project_id}/organizations/{organization_id}/onboarding-portal-links/{onboarding_portal_link_id} | Delete an organization onboarding portal link
*ProjectApi* | [**delete_project_api_key**](docs/ProjectApi.md#delete_project_api_key) | **DELETE** /projects/{project}/tokens/{token_id} | Delete project API key
*ProjectApi* | [**get_organization**](docs/ProjectApi.md#get_organization) | **GET** /projects/{project_id}/organizations/{organization_id} | Get Enterprise SSO Organization by ID
*ProjectApi* | [**get_organization_onboarding_portal_links**](docs/ProjectApi.md#get_organization_onboarding_portal_links) | **GET** /projects/{project_id}/organizations/{organization_id}/onboarding-portal-links | Get the organization onboarding portal links
*ProjectApi* | [**get_project**](docs/ProjectApi.md#get_project) | **GET** /projects/{project_id} | Get a Project
*ProjectApi* | [**get_project_members**](docs/ProjectApi.md#get_project_members) | **GET** /projects/{project}/members | Get all members associated with this project
*ProjectApi* | [**list_organizations**](docs/ProjectApi.md#list_organizations) | **GET** /projects/{project_id}/organizations | List all Enterprise SSO organizations
*ProjectApi* | [**list_project_api_keys**](docs/ProjectApi.md#list_project_api_keys) | **GET** /projects/{project}/tokens | List a project&#39;s API keys
*ProjectApi* | [**list_projects**](docs/ProjectApi.md#list_projects) | **GET** /projects | List All Projects
*ProjectApi* | [**patch_project**](docs/ProjectApi.md#patch_project) | **PATCH** /projects/{project_id} | Patch an Ory Network Project Configuration
*ProjectApi* | [**patch_project_with_revision**](docs/ProjectApi.md#patch_project_with_revision) | **PATCH** /projects/{project_id}/revision/{revision_id} | Patch an Ory Network Project Configuration based on a revision ID
*ProjectApi* | [**purge_project**](docs/ProjectApi.md#purge_project) | **DELETE** /projects/{project_id} | Irrecoverably purge a project
*ProjectApi* | [**remove_project_member**](docs/ProjectApi.md#remove_project_member) | **DELETE** /projects/{project}/members/{member} | Remove a member associated with this project
*ProjectApi* | [**set_project**](docs/ProjectApi.md#set_project) | **PUT** /projects/{project_id} | Update an Ory Network Project Configuration
*ProjectApi* | [**update_organization**](docs/ProjectApi.md#update_organization) | **PUT** /projects/{project_id}/organizations/{organization_id} | Update an Enterprise SSO Organization
*ProjectApi* | [**update_organization_onboarding_portal_link**](docs/ProjectApi.md#update_organization_onboarding_portal_link) | **POST** /projects/{project_id}/organizations/{organization_id}/onboarding-portal-links/{onboarding_portal_link_id} | Update organization onboarding portal link
*RelationshipApi* | [**check_opl_syntax**](docs/RelationshipApi.md#check_opl_syntax) | **POST** /opl/syntax/check | Check the syntax of an OPL file
*RelationshipApi* | [**create_relationship**](docs/RelationshipApi.md#create_relationship) | **PUT** /admin/relation-tuples | Create a Relationship
*RelationshipApi* | [**delete_relationships**](docs/RelationshipApi.md#delete_relationships) | **DELETE** /admin/relation-tuples | Delete Relationships
*RelationshipApi* | [**get_relationships**](docs/RelationshipApi.md#get_relationships) | **GET** /relation-tuples | Query relationships
*RelationshipApi* | [**list_relationship_namespaces**](docs/RelationshipApi.md#list_relationship_namespaces) | **GET** /namespaces | Query namespaces
*RelationshipApi* | [**patch_relationships**](docs/RelationshipApi.md#patch_relationships) | **PATCH** /admin/relation-tuples | Patch Multiple Relationships
*WellknownApi* | [**discover_json_web_keys**](docs/WellknownApi.md#discover_json_web_keys) | **GET** /.well-known/jwks.json | Discover Well-Known JSON Web Keys
*WorkspaceApi* | [**create_workspace**](docs/WorkspaceApi.md#create_workspace) | **POST** /workspaces | Create a new workspace
*WorkspaceApi* | [**create_workspace_api_key**](docs/WorkspaceApi.md#create_workspace_api_key) | **POST** /workspaces/{workspace}/tokens | Create workspace API key
*WorkspaceApi* | [**delete_workspace_api_key**](docs/WorkspaceApi.md#delete_workspace_api_key) | **DELETE** /workspaces/{workspace}/tokens/{token_id} | Delete workspace API key
*WorkspaceApi* | [**get_workspace**](docs/WorkspaceApi.md#get_workspace) | **GET** /workspaces/{workspace} | Get a workspace
*WorkspaceApi* | [**list_workspace_api_keys**](docs/WorkspaceApi.md#list_workspace_api_keys) | **GET** /workspaces/{workspace}/tokens | List a workspace&#39;s API keys
*WorkspaceApi* | [**list_workspace_projects**](docs/WorkspaceApi.md#list_workspace_projects) | **GET** /workspaces/{workspace}/projects | List all projects of a workspace
*WorkspaceApi* | [**list_workspaces**](docs/WorkspaceApi.md#list_workspaces) | **GET** /workspaces | List workspaces the user is a member of
*WorkspaceApi* | [**update_workspace**](docs/WorkspaceApi.md#update_workspace) | **PUT** /workspaces/{workspace} | Update an workspace


## Documentation For Models

 - [AcceptDeviceUserCodeRequest](docs/AcceptDeviceUserCodeRequest.md)
 - [AcceptOAuth2ConsentRequest](docs/AcceptOAuth2ConsentRequest.md)
 - [AcceptOAuth2ConsentRequestSession](docs/AcceptOAuth2ConsentRequestSession.md)
 - [AcceptOAuth2LoginRequest](docs/AcceptOAuth2LoginRequest.md)
 - [AccountExperienceColors](docs/AccountExperienceColors.md)
 - [AccountExperienceConfiguration](docs/AccountExperienceConfiguration.md)
 - [ActiveProjectInConsole](docs/ActiveProjectInConsole.md)
 - [AddProjectToWorkspaceBody](docs/AddProjectToWorkspaceBody.md)
 - [Attribute](docs/Attribute.md)
 - [AttributeFilter](docs/AttributeFilter.md)
 - [AttributesCountDatapoint](docs/AttributesCountDatapoint.md)
 - [AuthenticatorAssuranceLevel](docs/AuthenticatorAssuranceLevel.md)
 - [BasicOrganization](docs/BasicOrganization.md)
 - [BatchCheckPermissionBody](docs/BatchCheckPermissionBody.md)
 - [BatchCheckPermissionResult](docs/BatchCheckPermissionResult.md)
 - [BatchPatchIdentitiesResponse](docs/BatchPatchIdentitiesResponse.md)
 - [BillingPeriodBucket](docs/BillingPeriodBucket.md)
 - [CheckOplSyntaxResult](docs/CheckOplSyntaxResult.md)
 - [CheckPermissionResult](docs/CheckPermissionResult.md)
 - [CheckPermissionResultWithError](docs/CheckPermissionResultWithError.md)
 - [CloudAccount](docs/CloudAccount.md)
 - [ConsistencyRequestParameters](docs/ConsistencyRequestParameters.md)
 - [ContinueWith](docs/ContinueWith.md)
 - [ContinueWithRecoveryUi](docs/ContinueWithRecoveryUi.md)
 - [ContinueWithRecoveryUiFlow](docs/ContinueWithRecoveryUiFlow.md)
 - [ContinueWithRedirectBrowserTo](docs/ContinueWithRedirectBrowserTo.md)
 - [ContinueWithSetOrySessionToken](docs/ContinueWithSetOrySessionToken.md)
 - [ContinueWithSettingsUi](docs/ContinueWithSettingsUi.md)
 - [ContinueWithSettingsUiFlow](docs/ContinueWithSettingsUiFlow.md)
 - [ContinueWithVerificationUi](docs/ContinueWithVerificationUi.md)
 - [ContinueWithVerificationUiFlow](docs/ContinueWithVerificationUiFlow.md)
 - [CourierMessageStatus](docs/CourierMessageStatus.md)
 - [CourierMessageType](docs/CourierMessageType.md)
 - [CreateCustomDomainBody](docs/CreateCustomDomainBody.md)
 - [CreateEventStreamBody](docs/CreateEventStreamBody.md)
 - [CreateFedcmFlowResponse](docs/CreateFedcmFlowResponse.md)
 - [CreateIdentityBody](docs/CreateIdentityBody.md)
 - [CreateInviteResponse](docs/CreateInviteResponse.md)
 - [CreateJsonWebKeySet](docs/CreateJsonWebKeySet.md)
 - [CreateOrganizationOnboardingPortalLinkBody](docs/CreateOrganizationOnboardingPortalLinkBody.md)
 - [CreateProjectApiKeyRequest](docs/CreateProjectApiKeyRequest.md)
 - [CreateProjectBody](docs/CreateProjectBody.md)
 - [CreateProjectBranding](docs/CreateProjectBranding.md)
 - [CreateProjectMemberInviteBody](docs/CreateProjectMemberInviteBody.md)
 - [CreateProjectNormalizedPayload](docs/CreateProjectNormalizedPayload.md)
 - [CreateRecoveryCodeForIdentityBody](docs/CreateRecoveryCodeForIdentityBody.md)
 - [CreateRecoveryLinkForIdentityBody](docs/CreateRecoveryLinkForIdentityBody.md)
 - [CreateRelationshipBody](docs/CreateRelationshipBody.md)
 - [CreateSubscriptionBody](docs/CreateSubscriptionBody.md)
 - [CreateSubscriptionCommon](docs/CreateSubscriptionCommon.md)
 - [CreateVerifiableCredentialRequestBody](docs/CreateVerifiableCredentialRequestBody.md)
 - [CreateWorkspaceApiKeyBody](docs/CreateWorkspaceApiKeyBody.md)
 - [CreateWorkspaceBody](docs/CreateWorkspaceBody.md)
 - [CreateWorkspaceMemberInviteBody](docs/CreateWorkspaceMemberInviteBody.md)
 - [CreateWorkspaceSubscriptionBody](docs/CreateWorkspaceSubscriptionBody.md)
 - [CredentialSupportedDraft00](docs/CredentialSupportedDraft00.md)
 - [CustomDomain](docs/CustomDomain.md)
 - [DeleteMySessionsCount](docs/DeleteMySessionsCount.md)
 - [DeviceAuthorization](docs/DeviceAuthorization.md)
 - [DeviceUserAuthRequest](docs/DeviceUserAuthRequest.md)
 - [EmailTemplateData](docs/EmailTemplateData.md)
 - [EmailTemplateDataBody](docs/EmailTemplateDataBody.md)
 - [ErrorAuthenticatorAssuranceLevelNotSatisfied](docs/ErrorAuthenticatorAssuranceLevelNotSatisfied.md)
 - [ErrorBrowserLocationChangeRequired](docs/ErrorBrowserLocationChangeRequired.md)
 - [ErrorFlowReplaced](docs/ErrorFlowReplaced.md)
 - [ErrorGeneric](docs/ErrorGeneric.md)
 - [ErrorOAuth2](docs/ErrorOAuth2.md)
 - [EventStream](docs/EventStream.md)
 - [ExpandedPermissionTree](docs/ExpandedPermissionTree.md)
 - [FlowError](docs/FlowError.md)
 - [GenericError](docs/GenericError.md)
 - [GenericErrorContent](docs/GenericErrorContent.md)
 - [GenericUsage](docs/GenericUsage.md)
 - [GetAttributesCountResponse](docs/GetAttributesCountResponse.md)
 - [GetManagedIdentitySchemaLocation](docs/GetManagedIdentitySchemaLocation.md)
 - [GetMetricsEventAttributesResponse](docs/GetMetricsEventAttributesResponse.md)
 - [GetMetricsEventTypesResponse](docs/GetMetricsEventTypesResponse.md)
 - [GetOrganizationResponse](docs/GetOrganizationResponse.md)
 - [GetProjectEventsBody](docs/GetProjectEventsBody.md)
 - [GetProjectEventsResponse](docs/GetProjectEventsResponse.md)
 - [GetProjectMetricsResponse](docs/GetProjectMetricsResponse.md)
 - [GetSessionActivityResponse](docs/GetSessionActivityResponse.md)
 - [GetVersion200Response](docs/GetVersion200Response.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [Identity](docs/Identity.md)
 - [IdentityCredentials](docs/IdentityCredentials.md)
 - [IdentityCredentialsCode](docs/IdentityCredentialsCode.md)
 - [IdentityCredentialsCodeAddress](docs/IdentityCredentialsCodeAddress.md)
 - [IdentityCredentialsOidc](docs/IdentityCredentialsOidc.md)
 - [IdentityCredentialsOidcProvider](docs/IdentityCredentialsOidcProvider.md)
 - [IdentityCredentialsPassword](docs/IdentityCredentialsPassword.md)
 - [IdentityPatch](docs/IdentityPatch.md)
 - [IdentityPatchResponse](docs/IdentityPatchResponse.md)
 - [IdentitySchemaContainer](docs/IdentitySchemaContainer.md)
 - [IdentitySchemaPreset](docs/IdentitySchemaPreset.md)
 - [IdentityWithCredentials](docs/IdentityWithCredentials.md)
 - [IdentityWithCredentialsOidc](docs/IdentityWithCredentialsOidc.md)
 - [IdentityWithCredentialsOidcConfig](docs/IdentityWithCredentialsOidcConfig.md)
 - [IdentityWithCredentialsOidcConfigProvider](docs/IdentityWithCredentialsOidcConfigProvider.md)
 - [IdentityWithCredentialsPassword](docs/IdentityWithCredentialsPassword.md)
 - [IdentityWithCredentialsPasswordConfig](docs/IdentityWithCredentialsPasswordConfig.md)
 - [IdentityWithCredentialsSaml](docs/IdentityWithCredentialsSaml.md)
 - [IdentityWithCredentialsSamlConfig](docs/IdentityWithCredentialsSamlConfig.md)
 - [IdentityWithCredentialsSamlConfigProvider](docs/IdentityWithCredentialsSamlConfigProvider.md)
 - [InternalGetProjectBrandingBody](docs/InternalGetProjectBrandingBody.md)
 - [InternalIsAXWelcomeScreenEnabledForProjectBody](docs/InternalIsAXWelcomeScreenEnabledForProjectBody.md)
 - [InternalIsOwnerForProjectBySlugBody](docs/InternalIsOwnerForProjectBySlugBody.md)
 - [InternalIsOwnerForProjectBySlugResponse](docs/InternalIsOwnerForProjectBySlugResponse.md)
 - [IntrospectedOAuth2Token](docs/IntrospectedOAuth2Token.md)
 - [InviteTokenBody](docs/InviteTokenBody.md)
 - [Invoice](docs/Invoice.md)
 - [InvoiceDataV1](docs/InvoiceDataV1.md)
 - [IsOwnerForProjectBySlug](docs/IsOwnerForProjectBySlug.md)
 - [JsonPatch](docs/JsonPatch.md)
 - [JsonWebKey](docs/JsonWebKey.md)
 - [JsonWebKeySet](docs/JsonWebKeySet.md)
 - [KetoNamespace](docs/KetoNamespace.md)
 - [KeysetPaginationRequestParameters](docs/KeysetPaginationRequestParameters.md)
 - [KeysetPaginationResponseHeaders](docs/KeysetPaginationResponseHeaders.md)
 - [LineItemV1](docs/LineItemV1.md)
 - [ListEventStreams](docs/ListEventStreams.md)
 - [ListInvoicesResponse](docs/ListInvoicesResponse.md)
 - [ListOrganizationsResponse](docs/ListOrganizationsResponse.md)
 - [ListWorkspaceProjects](docs/ListWorkspaceProjects.md)
 - [ListWorkspaces](docs/ListWorkspaces.md)
 - [LoginFlow](docs/LoginFlow.md)
 - [LoginFlowState](docs/LoginFlowState.md)
 - [LogoutFlow](docs/LogoutFlow.md)
 - [ManagedIdentitySchema](docs/ManagedIdentitySchema.md)
 - [ManagedIdentitySchemaValidationResult](docs/ManagedIdentitySchemaValidationResult.md)
 - [MemberInvite](docs/MemberInvite.md)
 - [Message](docs/Message.md)
 - [MessageDispatch](docs/MessageDispatch.md)
 - [MetricsDatapoint](docs/MetricsDatapoint.md)
 - [Money](docs/Money.md)
 - [Namespace](docs/Namespace.md)
 - [NeedsPrivilegedSessionError](docs/NeedsPrivilegedSessionError.md)
 - [NormalizedProject](docs/NormalizedProject.md)
 - [NormalizedProjectRevision](docs/NormalizedProjectRevision.md)
 - [NormalizedProjectRevisionCourierChannel](docs/NormalizedProjectRevisionCourierChannel.md)
 - [NormalizedProjectRevisionHook](docs/NormalizedProjectRevisionHook.md)
 - [NormalizedProjectRevisionIdentitySchema](docs/NormalizedProjectRevisionIdentitySchema.md)
 - [NormalizedProjectRevisionSAMLProvider](docs/NormalizedProjectRevisionSAMLProvider.md)
 - [NormalizedProjectRevisionScimClient](docs/NormalizedProjectRevisionScimClient.md)
 - [NormalizedProjectRevisionThirdPartyProvider](docs/NormalizedProjectRevisionThirdPartyProvider.md)
 - [NormalizedProjectRevisionTokenizerTemplate](docs/NormalizedProjectRevisionTokenizerTemplate.md)
 - [OAuth2Client](docs/OAuth2Client.md)
 - [OAuth2ClientTokenLifespans](docs/OAuth2ClientTokenLifespans.md)
 - [OAuth2ConsentRequest](docs/OAuth2ConsentRequest.md)
 - [OAuth2ConsentRequestOpenIDConnectContext](docs/OAuth2ConsentRequestOpenIDConnectContext.md)
 - [OAuth2ConsentSession](docs/OAuth2ConsentSession.md)
 - [OAuth2LoginRequest](docs/OAuth2LoginRequest.md)
 - [OAuth2LogoutRequest](docs/OAuth2LogoutRequest.md)
 - [OAuth2RedirectTo](docs/OAuth2RedirectTo.md)
 - [OAuth2TokenExchange](docs/OAuth2TokenExchange.md)
 - [OidcConfiguration](docs/OidcConfiguration.md)
 - [OidcUserInfo](docs/OidcUserInfo.md)
 - [OnboardingPortalLink](docs/OnboardingPortalLink.md)
 - [OnboardingPortalOrganization](docs/OnboardingPortalOrganization.md)
 - [Organization](docs/Organization.md)
 - [OrganizationBody](docs/OrganizationBody.md)
 - [OrganizationOnboardingPortalLinksResponse](docs/OrganizationOnboardingPortalLinksResponse.md)
 - [ParseError](docs/ParseError.md)
 - [PatchIdentitiesBody](docs/PatchIdentitiesBody.md)
 - [PerformNativeLogoutBody](docs/PerformNativeLogoutBody.md)
 - [PermissionsOnWorkspace](docs/PermissionsOnWorkspace.md)
 - [Plan](docs/Plan.md)
 - [PlanDetails](docs/PlanDetails.md)
 - [PostCheckPermissionBody](docs/PostCheckPermissionBody.md)
 - [PostCheckPermissionOrErrorBody](docs/PostCheckPermissionOrErrorBody.md)
 - [Project](docs/Project.md)
 - [ProjectApiKey](docs/ProjectApiKey.md)
 - [ProjectBranding](docs/ProjectBranding.md)
 - [ProjectBrandingColors](docs/ProjectBrandingColors.md)
 - [ProjectBrandingTheme](docs/ProjectBrandingTheme.md)
 - [ProjectCors](docs/ProjectCors.md)
 - [ProjectEventsDatapoint](docs/ProjectEventsDatapoint.md)
 - [ProjectHost](docs/ProjectHost.md)
 - [ProjectMember](docs/ProjectMember.md)
 - [ProjectMetadata](docs/ProjectMetadata.md)
 - [ProjectServiceAccountExperience](docs/ProjectServiceAccountExperience.md)
 - [ProjectServiceIdentity](docs/ProjectServiceIdentity.md)
 - [ProjectServiceOAuth2](docs/ProjectServiceOAuth2.md)
 - [ProjectServicePermission](docs/ProjectServicePermission.md)
 - [ProjectServices](docs/ProjectServices.md)
 - [Provider](docs/Provider.md)
 - [QuotaUsage](docs/QuotaUsage.md)
 - [RFC6749ErrorJson](docs/RFC6749ErrorJson.md)
 - [RecoveryCodeForIdentity](docs/RecoveryCodeForIdentity.md)
 - [RecoveryFlow](docs/RecoveryFlow.md)
 - [RecoveryFlowState](docs/RecoveryFlowState.md)
 - [RecoveryIdentityAddress](docs/RecoveryIdentityAddress.md)
 - [RecoveryLinkForIdentity](docs/RecoveryLinkForIdentity.md)
 - [RegistrationFlow](docs/RegistrationFlow.md)
 - [RegistrationFlowState](docs/RegistrationFlowState.md)
 - [RejectOAuth2Request](docs/RejectOAuth2Request.md)
 - [RelationQuery](docs/RelationQuery.md)
 - [Relationship](docs/Relationship.md)
 - [RelationshipNamespaces](docs/RelationshipNamespaces.md)
 - [RelationshipPatch](docs/RelationshipPatch.md)
 - [Relationships](docs/Relationships.md)
 - [SchemaPatch](docs/SchemaPatch.md)
 - [SelfServiceFlowExpiredError](docs/SelfServiceFlowExpiredError.md)
 - [Session](docs/Session.md)
 - [SessionActivityDatapoint](docs/SessionActivityDatapoint.md)
 - [SessionAuthenticationMethod](docs/SessionAuthenticationMethod.md)
 - [SessionDevice](docs/SessionDevice.md)
 - [SetActiveProjectInConsoleBody](docs/SetActiveProjectInConsoleBody.md)
 - [SetCustomDomainBody](docs/SetCustomDomainBody.md)
 - [SetEventStreamBody](docs/SetEventStreamBody.md)
 - [SetOrganizationFromOnboardingPortalLinkBody](docs/SetOrganizationFromOnboardingPortalLinkBody.md)
 - [SetProject](docs/SetProject.md)
 - [SetProjectBrandingThemeBody](docs/SetProjectBrandingThemeBody.md)
 - [SettingsFlow](docs/SettingsFlow.md)
 - [SettingsFlowState](docs/SettingsFlowState.md)
 - [SourcePosition](docs/SourcePosition.md)
 - [SubjectSet](docs/SubjectSet.md)
 - [Subscription](docs/Subscription.md)
 - [SuccessfulCodeExchangeResponse](docs/SuccessfulCodeExchangeResponse.md)
 - [SuccessfulNativeLogin](docs/SuccessfulNativeLogin.md)
 - [SuccessfulNativeRegistration](docs/SuccessfulNativeRegistration.md)
 - [SuccessfulProjectUpdate](docs/SuccessfulProjectUpdate.md)
 - [TaxLineItem](docs/TaxLineItem.md)
 - [TimeInterval](docs/TimeInterval.md)
 - [TokenPagination](docs/TokenPagination.md)
 - [TokenPaginationHeaders](docs/TokenPaginationHeaders.md)
 - [TokenPaginationRequestParameters](docs/TokenPaginationRequestParameters.md)
 - [TokenPaginationResponseHeaders](docs/TokenPaginationResponseHeaders.md)
 - [TrustOAuth2JwtGrantIssuer](docs/TrustOAuth2JwtGrantIssuer.md)
 - [TrustedOAuth2JwtGrantIssuer](docs/TrustedOAuth2JwtGrantIssuer.md)
 - [TrustedOAuth2JwtGrantJsonWebKey](docs/TrustedOAuth2JwtGrantJsonWebKey.md)
 - [UiContainer](docs/UiContainer.md)
 - [UiNode](docs/UiNode.md)
 - [UiNodeAnchorAttributes](docs/UiNodeAnchorAttributes.md)
 - [UiNodeAttributes](docs/UiNodeAttributes.md)
 - [UiNodeDivisionAttributes](docs/UiNodeDivisionAttributes.md)
 - [UiNodeImageAttributes](docs/UiNodeImageAttributes.md)
 - [UiNodeInputAttributes](docs/UiNodeInputAttributes.md)
 - [UiNodeMeta](docs/UiNodeMeta.md)
 - [UiNodeScriptAttributes](docs/UiNodeScriptAttributes.md)
 - [UiNodeTextAttributes](docs/UiNodeTextAttributes.md)
 - [UiText](docs/UiText.md)
 - [UpdateFedcmFlowBody](docs/UpdateFedcmFlowBody.md)
 - [UpdateIdentityBody](docs/UpdateIdentityBody.md)
 - [UpdateLoginFlowBody](docs/UpdateLoginFlowBody.md)
 - [UpdateLoginFlowWithCodeMethod](docs/UpdateLoginFlowWithCodeMethod.md)
 - [UpdateLoginFlowWithIdentifierFirstMethod](docs/UpdateLoginFlowWithIdentifierFirstMethod.md)
 - [UpdateLoginFlowWithLookupSecretMethod](docs/UpdateLoginFlowWithLookupSecretMethod.md)
 - [UpdateLoginFlowWithOidcMethod](docs/UpdateLoginFlowWithOidcMethod.md)
 - [UpdateLoginFlowWithPasskeyMethod](docs/UpdateLoginFlowWithPasskeyMethod.md)
 - [UpdateLoginFlowWithPasswordMethod](docs/UpdateLoginFlowWithPasswordMethod.md)
 - [UpdateLoginFlowWithSamlMethod](docs/UpdateLoginFlowWithSamlMethod.md)
 - [UpdateLoginFlowWithTotpMethod](docs/UpdateLoginFlowWithTotpMethod.md)
 - [UpdateLoginFlowWithWebAuthnMethod](docs/UpdateLoginFlowWithWebAuthnMethod.md)
 - [UpdateOrganizationOnboardingPortalLinkBody](docs/UpdateOrganizationOnboardingPortalLinkBody.md)
 - [UpdateRecoveryFlowBody](docs/UpdateRecoveryFlowBody.md)
 - [UpdateRecoveryFlowWithCodeMethod](docs/UpdateRecoveryFlowWithCodeMethod.md)
 - [UpdateRecoveryFlowWithLinkMethod](docs/UpdateRecoveryFlowWithLinkMethod.md)
 - [UpdateRegistrationFlowBody](docs/UpdateRegistrationFlowBody.md)
 - [UpdateRegistrationFlowWithCodeMethod](docs/UpdateRegistrationFlowWithCodeMethod.md)
 - [UpdateRegistrationFlowWithOidcMethod](docs/UpdateRegistrationFlowWithOidcMethod.md)
 - [UpdateRegistrationFlowWithPasskeyMethod](docs/UpdateRegistrationFlowWithPasskeyMethod.md)
 - [UpdateRegistrationFlowWithPasswordMethod](docs/UpdateRegistrationFlowWithPasswordMethod.md)
 - [UpdateRegistrationFlowWithProfileMethod](docs/UpdateRegistrationFlowWithProfileMethod.md)
 - [UpdateRegistrationFlowWithSamlMethod](docs/UpdateRegistrationFlowWithSamlMethod.md)
 - [UpdateRegistrationFlowWithWebAuthnMethod](docs/UpdateRegistrationFlowWithWebAuthnMethod.md)
 - [UpdateSettingsFlowBody](docs/UpdateSettingsFlowBody.md)
 - [UpdateSettingsFlowWithLookupMethod](docs/UpdateSettingsFlowWithLookupMethod.md)
 - [UpdateSettingsFlowWithOidcMethod](docs/UpdateSettingsFlowWithOidcMethod.md)
 - [UpdateSettingsFlowWithPasskeyMethod](docs/UpdateSettingsFlowWithPasskeyMethod.md)
 - [UpdateSettingsFlowWithPasswordMethod](docs/UpdateSettingsFlowWithPasswordMethod.md)
 - [UpdateSettingsFlowWithProfileMethod](docs/UpdateSettingsFlowWithProfileMethod.md)
 - [UpdateSettingsFlowWithSamlMethod](docs/UpdateSettingsFlowWithSamlMethod.md)
 - [UpdateSettingsFlowWithTotpMethod](docs/UpdateSettingsFlowWithTotpMethod.md)
 - [UpdateSettingsFlowWithWebAuthnMethod](docs/UpdateSettingsFlowWithWebAuthnMethod.md)
 - [UpdateSubscriptionBody](docs/UpdateSubscriptionBody.md)
 - [UpdateVerificationFlowBody](docs/UpdateVerificationFlowBody.md)
 - [UpdateVerificationFlowWithCodeMethod](docs/UpdateVerificationFlowWithCodeMethod.md)
 - [UpdateVerificationFlowWithLinkMethod](docs/UpdateVerificationFlowWithLinkMethod.md)
 - [UpdateWorkspaceBody](docs/UpdateWorkspaceBody.md)
 - [Usage](docs/Usage.md)
 - [VerifiableCredentialPrimingResponse](docs/VerifiableCredentialPrimingResponse.md)
 - [VerifiableCredentialProof](docs/VerifiableCredentialProof.md)
 - [VerifiableCredentialResponse](docs/VerifiableCredentialResponse.md)
 - [VerifiableIdentityAddress](docs/VerifiableIdentityAddress.md)
 - [VerificationFlow](docs/VerificationFlow.md)
 - [VerificationFlowState](docs/VerificationFlowState.md)
 - [VerifyUserCodeRequest](docs/VerifyUserCodeRequest.md)
 - [Version](docs/Version.md)
 - [Warning](docs/Warning.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceApiKey](docs/WorkspaceApiKey.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="basic"></a>
### basic

- **Type**: HTTP basic authentication

<a id="bearer"></a>
### bearer

- **Type**: Bearer authentication

<a id="oauth2"></a>
### oauth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://hydra.demo.ory.sh/oauth2/auth
- **Scopes**: 
 - **offline**: A scope required when requesting refresh tokens (alias for `offline_access`)
 - **offline_access**: A scope required when requesting refresh tokens
 - **openid**: Request an OpenID Connect ID Token

<a id="oryAccessToken"></a>
### oryAccessToken

- **Type**: Bearer authentication

<a id="oryWorkspaceApiKey"></a>
### oryWorkspaceApiKey

- **Type**: Bearer authentication


## Author

support@ory.sh


