# coding: utf-8

"""
    Ory APIs

    # Introduction Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers.  ## SDKs This document describes the APIs available in the Ory Network. The APIs are available as SDKs for the following languages:  | Language       | Download SDK                                                     | Documentation                                                                        | | -------------- | ---------------------------------------------------------------- | ------------------------------------------------------------------------------------ | | Dart           | [pub.dev](https://pub.dev/packages/ory_client)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/dart/README.md)       | | .NET           | [nuget.org](https://www.nuget.org/packages/Ory.Client/)          | [README](https://github.com/ory/sdk/blob/master/clients/client/dotnet/README.md)     | | Elixir         | [hex.pm](https://hex.pm/packages/ory_client)                     | [README](https://github.com/ory/sdk/blob/master/clients/client/elixir/README.md)     | | Go             | [github.com](https://github.com/ory/client-go)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/go/README.md)         | | Java           | [maven.org](https://search.maven.org/artifact/sh.ory/ory-client) | [README](https://github.com/ory/sdk/blob/master/clients/client/java/README.md)       | | JavaScript     | [npmjs.com](https://www.npmjs.com/package/@ory/client)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript/README.md) | | JavaScript (With fetch) | [npmjs.com](https://www.npmjs.com/package/@ory/client-fetch)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript-fetch/README.md) |  | PHP            | [packagist.org](https://packagist.org/packages/ory/client)       | [README](https://github.com/ory/sdk/blob/master/clients/client/php/README.md)        | | Python         | [pypi.org](https://pypi.org/project/ory-client/)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/python/README.md)     | | Ruby           | [rubygems.org](https://rubygems.org/gems/ory-client)             | [README](https://github.com/ory/sdk/blob/master/clients/client/ruby/README.md)       | | Rust           | [crates.io](https://crates.io/crates/ory-client)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/rust/README.md)       | 

    The version of the OpenAPI document: v1.22.4
    Contact: support@ory.sh
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from ory_client.models.batch_check_permission_body import BatchCheckPermissionBody
from ory_client.models.batch_check_permission_result import BatchCheckPermissionResult
from ory_client.models.check_permission_result import CheckPermissionResult
from ory_client.models.expanded_permission_tree import ExpandedPermissionTree
from ory_client.models.post_check_permission_body import PostCheckPermissionBody
from ory_client.models.post_check_permission_or_error_body import PostCheckPermissionOrErrorBody

from ory_client.api_client import ApiClient, RequestSerialized
from ory_client.api_response import ApiResponse
from ory_client.rest import RESTResponseType


class PermissionApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def batch_check_permission(
        self,
        max_depth: Optional[StrictInt] = None,
        batch_check_permission_body: Optional[BatchCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> BatchCheckPermissionResult:
        """Batch check permissions

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param batch_check_permission_body:
        :type batch_check_permission_body: BatchCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_check_permission_serialize(
            max_depth=max_depth,
            batch_check_permission_body=batch_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchCheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def batch_check_permission_with_http_info(
        self,
        max_depth: Optional[StrictInt] = None,
        batch_check_permission_body: Optional[BatchCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[BatchCheckPermissionResult]:
        """Batch check permissions

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param batch_check_permission_body:
        :type batch_check_permission_body: BatchCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_check_permission_serialize(
            max_depth=max_depth,
            batch_check_permission_body=batch_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchCheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def batch_check_permission_without_preload_content(
        self,
        max_depth: Optional[StrictInt] = None,
        batch_check_permission_body: Optional[BatchCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Batch check permissions

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param batch_check_permission_body:
        :type batch_check_permission_body: BatchCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._batch_check_permission_serialize(
            max_depth=max_depth,
            batch_check_permission_body=batch_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "BatchCheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _batch_check_permission_serialize(
        self,
        max_depth,
        batch_check_permission_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if batch_check_permission_body is not None:
            _body_params = batch_check_permission_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/relation-tuples/batch/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def check_permission(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckPermissionResult:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def check_permission_with_http_info(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckPermissionResult]:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def check_permission_without_preload_content(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_permission_serialize(
        self,
        namespace,
        object,
        relation,
        subject_id,
        subject_set_namespace,
        subject_set_object,
        subject_set_relation,
        max_depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        if object is not None:
            
            _query_params.append(('object', object))
            
        if relation is not None:
            
            _query_params.append(('relation', relation))
            
        if subject_id is not None:
            
            _query_params.append(('subject_id', subject_id))
            
        if subject_set_namespace is not None:
            
            _query_params.append(('subject_set.namespace', subject_set_namespace))
            
        if subject_set_object is not None:
            
            _query_params.append(('subject_set.object', subject_set_object))
            
        if subject_set_relation is not None:
            
            _query_params.append(('subject_set.relation', subject_set_relation))
            
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/relation-tuples/check/openapi',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def check_permission_or_error(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckPermissionResult:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_or_error_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def check_permission_or_error_with_http_info(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckPermissionResult]:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_or_error_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def check_permission_or_error_without_preload_content(
        self,
        namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Relationship")] = None,
        object: Annotated[Optional[StrictStr], Field(description="Object of the Relationship")] = None,
        relation: Annotated[Optional[StrictStr], Field(description="Relation of the Relationship")] = None,
        subject_id: Annotated[Optional[StrictStr], Field(description="SubjectID of the Relationship")] = None,
        subject_set_namespace: Annotated[Optional[StrictStr], Field(description="Namespace of the Subject Set")] = None,
        subject_set_object: Annotated[Optional[StrictStr], Field(description="Object of the Subject Set")] = None,
        subject_set_relation: Annotated[Optional[StrictStr], Field(description="Relation of the Subject Set")] = None,
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param namespace: Namespace of the Relationship
        :type namespace: str
        :param object: Object of the Relationship
        :type object: str
        :param relation: Relation of the Relationship
        :type relation: str
        :param subject_id: SubjectID of the Relationship
        :type subject_id: str
        :param subject_set_namespace: Namespace of the Subject Set
        :type subject_set_namespace: str
        :param subject_set_object: Object of the Subject Set
        :type subject_set_object: str
        :param subject_set_relation: Relation of the Subject Set
        :type subject_set_relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._check_permission_or_error_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            subject_id=subject_id,
            subject_set_namespace=subject_set_namespace,
            subject_set_object=subject_set_object,
            subject_set_relation=subject_set_relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _check_permission_or_error_serialize(
        self,
        namespace,
        object,
        relation,
        subject_id,
        subject_set_namespace,
        subject_set_object,
        subject_set_relation,
        max_depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        if object is not None:
            
            _query_params.append(('object', object))
            
        if relation is not None:
            
            _query_params.append(('relation', relation))
            
        if subject_id is not None:
            
            _query_params.append(('subject_id', subject_id))
            
        if subject_set_namespace is not None:
            
            _query_params.append(('subject_set.namespace', subject_set_namespace))
            
        if subject_set_object is not None:
            
            _query_params.append(('subject_set.object', subject_set_object))
            
        if subject_set_relation is not None:
            
            _query_params.append(('subject_set.relation', subject_set_relation))
            
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/relation-tuples/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def expand_permissions(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace of the Subject Set")],
        object: Annotated[StrictStr, Field(description="Object of the Subject Set")],
        relation: Annotated[StrictStr, Field(description="Relation of the Subject Set")],
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ExpandedPermissionTree:
        """Expand a Relationship into permissions.

        Use this endpoint to expand a relationship tuple into permissions.

        :param namespace: Namespace of the Subject Set (required)
        :type namespace: str
        :param object: Object of the Subject Set (required)
        :type object: str
        :param relation: Relation of the Subject Set (required)
        :type relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._expand_permissions_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExpandedPermissionTree",
            '400': "ErrorGeneric",
            '404': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def expand_permissions_with_http_info(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace of the Subject Set")],
        object: Annotated[StrictStr, Field(description="Object of the Subject Set")],
        relation: Annotated[StrictStr, Field(description="Relation of the Subject Set")],
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ExpandedPermissionTree]:
        """Expand a Relationship into permissions.

        Use this endpoint to expand a relationship tuple into permissions.

        :param namespace: Namespace of the Subject Set (required)
        :type namespace: str
        :param object: Object of the Subject Set (required)
        :type object: str
        :param relation: Relation of the Subject Set (required)
        :type relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._expand_permissions_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExpandedPermissionTree",
            '400': "ErrorGeneric",
            '404': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def expand_permissions_without_preload_content(
        self,
        namespace: Annotated[StrictStr, Field(description="Namespace of the Subject Set")],
        object: Annotated[StrictStr, Field(description="Object of the Subject Set")],
        relation: Annotated[StrictStr, Field(description="Relation of the Subject Set")],
        max_depth: Optional[StrictInt] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Expand a Relationship into permissions.

        Use this endpoint to expand a relationship tuple into permissions.

        :param namespace: Namespace of the Subject Set (required)
        :type namespace: str
        :param object: Object of the Subject Set (required)
        :type object: str
        :param relation: Relation of the Subject Set (required)
        :type relation: str
        :param max_depth:
        :type max_depth: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._expand_permissions_serialize(
            namespace=namespace,
            object=object,
            relation=relation,
            max_depth=max_depth,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ExpandedPermissionTree",
            '400': "ErrorGeneric",
            '404': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _expand_permissions_serialize(
        self,
        namespace,
        object,
        relation,
        max_depth,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if namespace is not None:
            
            _query_params.append(('namespace', namespace))
            
        if object is not None:
            
            _query_params.append(('object', object))
            
        if relation is not None:
            
            _query_params.append(('relation', relation))
            
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/relation-tuples/expand',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_check_permission(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_body: Optional[PostCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckPermissionResult:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_body:
        :type post_check_permission_body: PostCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_serialize(
            max_depth=max_depth,
            post_check_permission_body=post_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_check_permission_with_http_info(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_body: Optional[PostCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckPermissionResult]:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_body:
        :type post_check_permission_body: PostCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_serialize(
            max_depth=max_depth,
            post_check_permission_body=post_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_check_permission_without_preload_content(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_body: Optional[PostCheckPermissionBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_body:
        :type post_check_permission_body: PostCheckPermissionBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_serialize(
            max_depth=max_depth,
            post_check_permission_body=post_check_permission_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_check_permission_serialize(
        self,
        max_depth,
        post_check_permission_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_check_permission_body is not None:
            _body_params = post_check_permission_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/relation-tuples/check/openapi',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_check_permission_or_error(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_or_error_body: Optional[PostCheckPermissionOrErrorBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CheckPermissionResult:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_or_error_body:
        :type post_check_permission_or_error_body: PostCheckPermissionOrErrorBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_or_error_serialize(
            max_depth=max_depth,
            post_check_permission_or_error_body=post_check_permission_or_error_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_check_permission_or_error_with_http_info(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_or_error_body: Optional[PostCheckPermissionOrErrorBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CheckPermissionResult]:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_or_error_body:
        :type post_check_permission_or_error_body: PostCheckPermissionOrErrorBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_or_error_serialize(
            max_depth=max_depth,
            post_check_permission_or_error_body=post_check_permission_or_error_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_check_permission_or_error_without_preload_content(
        self,
        max_depth: Optional[StrictInt] = None,
        post_check_permission_or_error_body: Optional[PostCheckPermissionOrErrorBody] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Check a permission

        To learn how relationship tuples and the check works, head over to [the documentation](https://www.ory.sh/docs/keto/concepts/api-overview).

        :param max_depth:
        :type max_depth: int
        :param post_check_permission_or_error_body:
        :type post_check_permission_or_error_body: PostCheckPermissionOrErrorBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_check_permission_or_error_serialize(
            max_depth=max_depth,
            post_check_permission_or_error_body=post_check_permission_or_error_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CheckPermissionResult",
            '400': "ErrorGeneric",
            '403': "CheckPermissionResult",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_check_permission_or_error_serialize(
        self,
        max_depth,
        post_check_permission_or_error_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if max_depth is not None:
            
            _query_params.append(('max-depth', max_depth))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if post_check_permission_or_error_body is not None:
            _body_params = post_check_permission_or_error_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'oryAccessToken'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/relation-tuples/check',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


