"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Table = exports.TableProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ots_generated_1 = require("./ots.generated");
Object.defineProperty(exports, "TableProperty", { enumerable: true, get: function () { return ots_generated_1.RosTable; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::OTS::Table`, which is used to create a table based on a specified schema.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosTable`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ots-table
 */
class Table extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosTable = new ots_generated_1.RosTable(this, id, {
            instanceName: props.instanceName,
            tableName: props.tableName,
            timeToLive: props.timeToLive === undefined || props.timeToLive === null ? -1 : props.timeToLive,
            maxVersions: props.maxVersions === undefined || props.maxVersions === null ? 1 : props.maxVersions,
            secondaryIndices: props.secondaryIndices,
            deviationCellVersionInSec: props.deviationCellVersionInSec === undefined || props.deviationCellVersionInSec === null ? 86400 : props.deviationCellVersionInSec,
            primaryKey: props.primaryKey,
            columns: props.columns,
            reservedThroughput: props.reservedThroughput,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosTable;
        this.attrTableName = rosTable.attrTableName;
    }
}
exports.Table = Table;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFibGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0YWJsZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTJDO0FBRXRCLDhGQUZaLHdCQUFRLE9BRWlCO0FBaUVsQzs7OztHQUlHO0FBQ0gsTUFBYSxLQUFNLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFXbkM7Ozs7T0FJRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBaUIsRUFBRSxtQ0FBMkMsSUFBSTtRQUM1RyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2pCLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDO1FBQ2IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7UUFDbkIsSUFBSSxDQUFDLGdDQUFnQyxHQUFHLGdDQUFnQyxDQUFDO1FBRXpFLE1BQU0sUUFBUSxHQUFHLElBQUksd0JBQVEsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQ3JDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxTQUFTLEVBQUUsS0FBSyxDQUFDLFNBQVM7WUFDMUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxVQUFVLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFVBQVU7WUFDL0YsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXLEtBQUssU0FBUyxJQUFJLEtBQUssQ0FBQyxXQUFXLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxXQUFXO1lBQ2xHLGdCQUFnQixFQUFFLEtBQUssQ0FBQyxnQkFBZ0I7WUFDeEMseUJBQXlCLEVBQUUsS0FBSyxDQUFDLHlCQUF5QixLQUFLLFNBQVMsSUFBSSxLQUFLLENBQUMseUJBQXlCLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyx5QkFBeUI7WUFDOUosVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVO1lBQzVCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1NBQy9DLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxhQUFhLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQztJQUNoRCxDQUFDO0NBQ0o7QUFyQ0Qsc0JBcUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zVGFibGUgfSBmcm9tICcuL290cy5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NUYWJsZSBhcyBUYWJsZVByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgVGFibGVgLlxuICogU2VlIGh0dHBzOi8vd3d3LmFsaWJhYmFjbG91ZC5jb20vaGVscC9yb3MvZGV2ZWxvcGVyLXJlZmVyZW5jZS9hbGl5dW4tb3RzLXRhYmxlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVGFibGVQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBpbnN0YW5jZU5hbWU6IFRoZSBuYW1lIG9mIHRoZSBPVFMgaW5zdGFuY2UgaW4gd2hpY2ggdGFibGUgd2lsbCBsb2NhdGUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VOYW1lOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwcmltYXJ5S2V5OiBJdCBkZXNjcmliZXMgdGhlIGF0dHJpYnV0ZSB2YWx1ZSBvZiBwcmltYXJ5IGtleS4gVGhlIG51bWJlciBvZiBwcmltYXJ5X2tleSBzaG91bGQgbm90IGJlIGxlc3MgdGhhbiBvbmUgYW5kIG5vdCBiZSBtb3JlIHRoYW4gZm91ci5cbiAgICAgKi9cbiAgICByZWFkb25seSBwcmltYXJ5S2V5OiBBcnJheTxSb3NUYWJsZS5QcmltYXJ5S2V5UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGFibGVOYW1lOiBUaGUgdGFibGUgbmFtZSBvZiB0aGUgT1RTIGluc3RhbmNlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRhYmxlTmFtZTogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgY29sdW1uczogQXR0cmlidXRlIGNvbHVtbiBmb3IgdGFibGUgc3RvcmUuXG4gICAgICovXG4gICAgcmVhZG9ubHkgY29sdW1ucz86IEFycmF5PFJvc1RhYmxlLkNvbHVtbnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkZXZpYXRpb25DZWxsVmVyc2lvbkluU2VjOiBNYXhpbXVtIHZlcnNpb24gZGV2aWF0aW9uLiBUaGUgcHVycG9zZSBpcyBtYWlubHkgdG8gcHJvaGliaXQgd3JpdGluZyBhbmQgZXhwZWN0ZWQgbGFyZ2UgZGF0YSwgc3VjaCBhcyBzZXR0aW5nIHRoZSBkZXZpYXRpb25fY2VsbF92ZXJzaW9uX2luX3NlYyB0byAxMDAwLCBhbmQgaWYgdGhlIGN1cnJlbnQgdGltZXN0YW1wIGlzIDEwMDAwLCB0aGUgdGltZXN0YW1wIHJhbmdlIGFsbG93ZWQgdG8gYmUgd3JpdHRlbiBpcyBbMTAwMDAgLSAxMDAwLCAxMDAwMCArIDEwMDBdLiBUaGUgdmFsaWQgdmFsdWUgaXMgMS05MjIzMzcyMDM2ODU0Nzc1ODA3LiBEZWZhdWx0cyB0byA4NjQwMC5cbiAgICAgKi9cbiAgICByZWFkb25seSBkZXZpYXRpb25DZWxsVmVyc2lvbkluU2VjPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbWF4VmVyc2lvbnM6IFRoZSBtYXhpbXVtIG51bWJlciBvZiB2ZXJzaW9ucyBzdG9yZWQgaW4gdGhpcyB0YWJsZS4gVGhlIHZhbGlkIHZhbHVlIGlzIDEtMjE0NzQ4MzY0Ny4gRGVmYXVsdCB0byAxLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG1heFZlcnNpb25zPzogbnVtYmVyIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgcmVzZXJ2ZWRUaHJvdWdocHV0OiBUaGUgaW5pdGlhbCByZXNlcnZlZCByZWFkXFwvd3JpdGUgdGhyb3VnaHB1dCBzZXR0aW5nIG9mIHRoZSB0YWJsZSB0byBiZSBjcmVhdGVkLCB0aGUgcmVzZXJ2ZWQgcmVhZCB0aHJvdWdocHV0IGFuZCByZXNlcnZlZCB3cml0ZSB0aHJvdWdocHV0IG9mIGFueSB0YWJsZSBjYW5ub3QgZXhjZWVkIDUwMDAuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcmVzZXJ2ZWRUaHJvdWdocHV0PzogUm9zVGFibGUuUmVzZXJ2ZWRUaHJvdWdocHV0UHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBzZWNvbmRhcnlJbmRpY2VzOiBUaGUgc2Vjb25kYXJ5IGluZGljZXMgb2YgdGhlIHRhYmxlLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IHNlY29uZGFyeUluZGljZXM/OiBBcnJheTxSb3NUYWJsZS5TZWNvbmRhcnlJbmRpY2VzUHJvcGVydHkgfCByb3MuSVJlc29sdmFibGU+IHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgdGltZVRvTGl2ZTogVGhlIHJldGVudGlvbiB0aW1lIG9mIGRhdGEgc3RvcmVkIGluIHRoaXMgdGFibGUgKHVuaXQ6IHNlY29uZCkuIFRoZSB2YWx1ZSBtYXhpbXVtIGlzIDIxNDc0ODM2NDcgYW5kIC0xIG1lYW5zIG5ldmVyIGV4cGlyZWQuIERlZmF1bHQgdG8gLTEuXG4gICAgICovXG4gICAgcmVhZG9ubHkgdGltZVRvTGl2ZT86IG51bWJlciB8IHJvcy5JUmVzb2x2YWJsZTtcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIGEgYFRhYmxlYC5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBJVGFibGUgZXh0ZW5kcyByb3MuSVJlc291cmNlIHtcbiAgICByZWFkb25seSBwcm9wczogVGFibGVQcm9wcztcblxuICAgIC8qKlxuICAgICAqIEF0dHJpYnV0ZSBUYWJsZU5hbWU6IFRhYmxlIG5hbWVcbiAgICAgKi9cbiAgICByZWFkb25seSBhdHRyVGFibGVOYW1lOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG59XG4vKipcbiAqIFRoaXMgY2xhc3MgZW5jYXBzdWxhdGVzIGFuZCBleHRlbmRzIHRoZSBST1MgcmVzb3VyY2UgdHlwZSBgQUxJWVVOOjpPVFM6OlRhYmxlYCwgd2hpY2ggaXMgdXNlZCB0byBjcmVhdGUgYSB0YWJsZSBiYXNlZCBvbiBhIHNwZWNpZmllZCBzY2hlbWEuXG4gKiBATm90ZSBUaGlzIGNsYXNzIG1heSBoYXZlIHNvbWUgbmV3IGZ1bmN0aW9ucyB0byBmYWNpbGl0YXRlIGRldmVsb3BtZW50LCBzbyBpdCBpcyByZWNvbW1lbmRlZCB0byB1c2UgdGhpcyBjbGFzcyBpbnN0ZWFkIG9mIGBSb3NUYWJsZWBmb3IgYSBtb3JlIGNvbnZlbmllbnQgZGV2ZWxvcG1lbnQgZXhwZXJpZW5jZS5cbiAqIFNlZSBodHRwczovL3d3dy5hbGliYWJhY2xvdWQuY29tL2hlbHAvcm9zL2RldmVsb3Blci1yZWZlcmVuY2UvYWxpeXVuLW90cy10YWJsZVxuICovXG5leHBvcnQgY2xhc3MgVGFibGUgZXh0ZW5kcyByb3MuUmVzb3VyY2UgaW1wbGVtZW50cyBJVGFibGUge1xuICAgIHByb3RlY3RlZCBzY29wZTogcm9zLkNvbnN0cnVjdDtcbiAgICBwcm90ZWN0ZWQgaWQ6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgcHJvcHM6IFRhYmxlUHJvcHM7XG4gICAgcHJvdGVjdGVkIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OiBib29sZWFuO1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIFRhYmxlTmFtZTogVGFibGUgbmFtZVxuICAgICAqL1xuICAgIHB1YmxpYyByZWFkb25seSBhdHRyVGFibGVOYW1lOiByb3MuSVJlc29sdmFibGUgfCBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVGFibGVQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICAgICAgdGhpcy5zY29wZSA9IHNjb3BlO1xuICAgICAgICB0aGlzLmlkID0gaWQ7XG4gICAgICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgICAgICAgdGhpcy5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCA9IGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50O1xuXG4gICAgICAgIGNvbnN0IHJvc1RhYmxlID0gbmV3IFJvc1RhYmxlKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgaW5zdGFuY2VOYW1lOiBwcm9wcy5pbnN0YW5jZU5hbWUsXG4gICAgICAgICAgICB0YWJsZU5hbWU6IHByb3BzLnRhYmxlTmFtZSxcbiAgICAgICAgICAgIHRpbWVUb0xpdmU6IHByb3BzLnRpbWVUb0xpdmUgPT09IHVuZGVmaW5lZCB8fCBwcm9wcy50aW1lVG9MaXZlID09PSBudWxsID8gLTEgOiBwcm9wcy50aW1lVG9MaXZlLFxuICAgICAgICAgICAgbWF4VmVyc2lvbnM6IHByb3BzLm1heFZlcnNpb25zID09PSB1bmRlZmluZWQgfHwgcHJvcHMubWF4VmVyc2lvbnMgPT09IG51bGwgPyAxIDogcHJvcHMubWF4VmVyc2lvbnMsXG4gICAgICAgICAgICBzZWNvbmRhcnlJbmRpY2VzOiBwcm9wcy5zZWNvbmRhcnlJbmRpY2VzLFxuICAgICAgICAgICAgZGV2aWF0aW9uQ2VsbFZlcnNpb25JblNlYzogcHJvcHMuZGV2aWF0aW9uQ2VsbFZlcnNpb25JblNlYyA9PT0gdW5kZWZpbmVkIHx8IHByb3BzLmRldmlhdGlvbkNlbGxWZXJzaW9uSW5TZWMgPT09IG51bGwgPyA4NjQwMCA6IHByb3BzLmRldmlhdGlvbkNlbGxWZXJzaW9uSW5TZWMsXG4gICAgICAgICAgICBwcmltYXJ5S2V5OiBwcm9wcy5wcmltYXJ5S2V5LFxuICAgICAgICAgICAgY29sdW1uczogcHJvcHMuY29sdW1ucyxcbiAgICAgICAgICAgIHJlc2VydmVkVGhyb3VnaHB1dDogcHJvcHMucmVzZXJ2ZWRUaHJvdWdocHV0LFxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcbiAgICAgICAgdGhpcy5yZXNvdXJjZSA9IHJvc1RhYmxlO1xuICAgICAgICB0aGlzLmF0dHJUYWJsZU5hbWUgPSByb3NUYWJsZS5hdHRyVGFibGVOYW1lO1xuICAgIH1cbn1cbiJdfQ==