from PyQt6 import QtWidgets

from vars_gridview.ui.settings.tabs.AbstractSettingsTab import AbstractSettingsTab


class AppearanceTab(AbstractSettingsTab):
    """
    Application appearance tab.
    """

    def __init__(self, parent=None):
        super().__init__("Appearance", parent=parent)

        self.label_font_size_spinbox = QtWidgets.QSpinBox()
        self.label_font_size_spinbox.setMinimum(4)
        self.label_font_size_spinbox.setMaximum(12)
        self.label_font_size_spinbox.setValue(self._settings.label_font_size.value)
        self.label_font_size_spinbox.valueChanged.connect(self.settingsChanged.emit)
        self._settings.label_font_size.valueChanged.connect(
            self.label_font_size_spinbox.setValue
        )

        self.selection_highlight_color_button = QtWidgets.QPushButton()
        self.selection_highlight_color_button.clicked.connect(self.select_color)
        self._selection_highlight_color = self._settings.selection_highlight_color.value
        self._update_selection_highlight_color_button()
        self._settings.selection_highlight_color.valueChanged.connect(
            self._update_selection_highlight_color_button
        )

        self.arrange()

    def select_color(self):
        color = QtWidgets.QColorDialog.getColor()
        if color.isValid():
            self._selection_highlight_color = color.name()
            self._settings.selection_highlight_color.value = self._selection_highlight_color
    
    def _update_selection_highlight_color_button(self):
        self.selection_highlight_color_button.setStyleSheet(
            f"background-color: {self._selection_highlight_color};"
        )

    def arrange(self):
        layout = QtWidgets.QFormLayout()

        layout.addRow("Label font size", self.label_font_size_spinbox)
        layout.addRow("Selection highlight color", self.selection_highlight_color_button)

        self.setLayout(layout)

    def apply_settings(self):
        self._settings.label_font_size.value = self.label_font_size_spinbox.value()
        self._settings.selection_highlight_color.value = self._selection_highlight_color
