#  ✩°｡⋆ Contributing to the project ⋆｡°✩

First off, thank you for considering contributing! **ദ്ദി(˵ •̀ ᴗ - ˵ ) ✧**  
Whether you’re filing a bug, proposing a new feature, improving documentation, or refactoring code, your help makes this project better for you and the whole community.

## Code of Conduct
This project adheres to the [Contributor Covenant v2.1](https://www.contributor-covenant.org/version/2/1/code_of_conduct/).  
By participating, you agree to respect everyone in this community. **˗ˏˋ ♡ ˎˊ˗**

## Table of Contents

1. [Getting Started](#getting-started)  
2. [I Have a Question](#i-have-a-question)  
3. [Reporting Bugs](#reporting-bugs)  
4. [Suggesting Enhancements](#suggesting-enhancements)  
5. [Your First Code Contribution](#your-first-code-contribution)  
6. [Pull Request Process](#pull-request-process)  
7. [Coding Style & Tests](#coding-style--tests)  
8. [Writing Documentation](#writing-documentation)  
9. [Where to Get Help](#where-to-get-help)

## Getting started
1. Fork the repo and clone your fork
```bash
git clone https://github.com/yungselm/multimoda-rs.git
cd multimoda-rs
```
2. Create a new branch
```bash
git checkout -b feature/sick-feature
```
3. install dependencies and run tests
```bash
pip install -e
pytest
```
## I have a Question 
Before opening an issue:
- Read the [Documentation](https://multimoda-rs.readthedocs.io/en/latest/index.html)
- Search existing [Issues](https://github.com/yungselm/multimoda-rs/issues?q=is%3Aissue) 

If you still need help:
- Open a new issue: [Click here](https://github.com/yungselm/multimoda-rs/issues/new/choose)
- Provide:
    - A clear, descriptive title
    - Context: what you're trying to do, expected vs. actual behaviour
    - Project verion, OS/platform, Python version, and any relevant logs

## Reporting Bugs
If you find a bug, please help us fix it by opening a [a new issue](https://github.com/yungselm/multimoda-rs/issues/new/choose) and providing:
- **Title**: A short descriptive title
- **Steps to reproduce**: Minimal code snippet or sequence to trigger the bug
- **Expected behaviour** vs **Actual behaviour**
- **Environment**:
    - `multimoda-rs` version
    - Python version
    - OS and architecture


**ฅ^>⩊<^ ฅ**
------------------------------------------------------------------------------------