#############################################################################
##
## MIT License
## 
## Copyright (c) 2021 tonquer
## 
## Permission is hereby granted, free of charge, to any person obtaining a copy
## of this software and associated documentation files (the "Software"), to deal
## in the Software without restriction, including without limitation the rights
## to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
## copies of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
## 
## The above copyright notice and this permission notice shall be included in all
## copies or substantial portions of the Software.
## 
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
## AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
## OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.
##
#############################################################################
"""
This file contains the exact signatures for all functions in module
sr_vulkan.sr_vulkan, except for defaults which are replaced by "...".
"""

# Module `sr_vulkan.sr_vulkan`

from typing import Tuple, overload, Union, Optional, List
from typing_extensions import Literal
import sr_vulkan

MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X        = ... 
MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X        = ...
MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X        = ...
MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X        = ...
MODEL_WAIFU2X_CUNET_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X                  = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X        = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X        = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X        = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X        = ...
MODEL_WAIFU2X_ANIME_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X                  = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X        = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X        = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X        = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X        = ...
MODEL_WAIFU2X_PHOTO_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X                  = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X        = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X        = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X        = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X        = ...
MODEL_REALCUGAN_PRO_UP2X                    : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X                  = ...
MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE       : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE     = ...
MODEL_REALCUGAN_PRO_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_DENOISE3X        = ...
MODEL_REALCUGAN_PRO_UP3X                    : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X                  = ...
MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE       : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE     = ...
MODEL_REALCUGAN_PRO_UP3X_DENOISE3X          : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_DENOISE3X        = ...
MODEL_REALCUGAN_SE_UP2X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X                   = ...
MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE      = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE1X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE1X         = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE2X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE2X         = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE3X         = ...
MODEL_REALCUGAN_SE_UP3X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X                   = ...
MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE      = ...
MODEL_REALCUGAN_SE_UP3X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_DENOISE3X         = ...
MODEL_REALCUGAN_SE_UP4X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X                   = ...
MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE      = ...
MODEL_REALCUGAN_SE_UP4X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_DENOISE3X         = ...
MODEL_REALSR_DF2K_UP4X                      : sr_vulkan.MODEL.MODEL_REALSR_DF2K_UP4X                    = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X                    = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X                    = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X                    = ...
MODEL_REALESRGAN_X4PLUS_UP4X                : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUS_UP4X                    = ...
MODEL_REALESRGAN_X4PLUSANIME_UP4X           : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUSANIME_UP4X                    = ...

MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_TTA              = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X_TTA    = ...
MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X_TTA    = ...
MODEL_WAIFU2X_ANIME_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_TTA              = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X_TTA    = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X_TTA    = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X_TTA    = ...
MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X_TTA    = ...
MODEL_WAIFU2X_PHOTO_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_TTA              = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X_TTA    = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X_TTA    = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X_TTA    = ...
MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X_TTA    = ...
MODEL_REALCUGAN_PRO_UP2X_TTA                : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_TTA              = ...
MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE_TTA   : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE_TTA = ...
MODEL_REALCUGAN_PRO_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_DENOISE3X_TTA    = ...
MODEL_REALCUGAN_PRO_UP3X_TTA                : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_TTA              = ...
MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE_TTA   : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE_TTA = ...
MODEL_REALCUGAN_PRO_UP3X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_DENOISE3X_TTA    = ...
MODEL_REALCUGAN_SE_UP2X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_TTA               = ...
MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE_TTA  = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE1X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE1X_TTA     = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE2X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE2X_TTA     = ...
MODEL_REALCUGAN_SE_UP2X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE3X_TTA     = ...
MODEL_REALCUGAN_SE_UP3X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_TTA               = ...
MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE_TTA  = ...
MODEL_REALCUGAN_SE_UP3X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_DENOISE3X_TTA     = ...
MODEL_REALCUGAN_SE_UP4X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_TTA               = ...
MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE_TTA  = ...
MODEL_REALCUGAN_SE_UP4X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_DENOISE3X_TTA     = ...
MODEL_REALSR_DF2K_UP4X_TTA                  : sr_vulkan.MODEL.MODEL_REALSR_DF2K_UP4X_TTA                = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X_TTA                    = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X_TTA                    = ...
MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X_TTA                    = ...
MODEL_REALESRGAN_X4PLUS_UP4X_TTA                : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUS_UP4X_TTA                    = ...
MODEL_REALESRGAN_X4PLUSANIME_UP4X_TTA           : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUSANIME_UP4X_TTA                    = ...

class MODEL:
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X        = ... 
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X        = ...
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X        = ...
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X        = ...
    MODEL_WAIFU2X_CUNET_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X                  = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X        = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X        = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X        = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X        = ...
    MODEL_WAIFU2X_ANIME_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X                  = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X        = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X        = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X        = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X        = ...
    MODEL_WAIFU2X_PHOTO_UP2X                    : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X                  = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X        = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X        = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X        = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X        = ...
    MODEL_REALCUGAN_PRO_UP2X                    : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X                  = ...
    MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE       : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE     = ...
    MODEL_REALCUGAN_PRO_UP2X_DENOISE3X          : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_DENOISE3X        = ...
    MODEL_REALCUGAN_PRO_UP3X                    : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X                  = ...
    MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE       : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE     = ...
    MODEL_REALCUGAN_PRO_UP3X_DENOISE3X          : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_DENOISE3X        = ...
    MODEL_REALCUGAN_SE_UP2X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X                   = ...
    MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE      = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE1X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE1X         = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE2X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE2X         = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE3X         = ...
    MODEL_REALCUGAN_SE_UP3X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X                   = ...
    MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE      = ...
    MODEL_REALCUGAN_SE_UP3X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_DENOISE3X         = ...
    MODEL_REALCUGAN_SE_UP4X                     : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X                   = ...
    MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE        : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE      = ...
    MODEL_REALCUGAN_SE_UP4X_DENOISE3X           : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_DENOISE3X         = ...
    MODEL_REALSR_DF2K_UP4X                      : sr_vulkan.MODEL.MODEL_REALSR_DF2K_UP4X                    = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X                    = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X                    = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X                    = ...
    MODEL_REALESRGAN_X4PLUS_UP4X                : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUS_UP4X                    = ...
    MODEL_REALESRGAN_X4PLUSANIME_UP4X           : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUSANIME_UP4X                    = ...

    MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE0X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE1X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE2X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP1X_DENOISE3X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_TTA              = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE0X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE1X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE2X_TTA    = ...
    MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_CUNET_UP2X_DENOISE3X_TTA    = ...
    MODEL_WAIFU2X_ANIME_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_TTA              = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE0X_TTA    = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE1X_TTA    = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE2X_TTA    = ...
    MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_ANIME_UP2X_DENOISE3X_TTA    = ...
    MODEL_WAIFU2X_PHOTO_UP2X_TTA                : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_TTA              = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE0X_TTA    = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE1X_TTA    = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE2X_TTA    = ...
    MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_WAIFU2X_PHOTO_UP2X_DENOISE3X_TTA    = ...
    MODEL_REALCUGAN_PRO_UP2X_TTA                : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_TTA              = ...
    MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE_TTA   : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_CONSERVATIVE_TTA = ...
    MODEL_REALCUGAN_PRO_UP2X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP2X_DENOISE3X_TTA    = ...
    MODEL_REALCUGAN_PRO_UP3X_TTA                : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_TTA              = ...
    MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE_TTA   : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_CONSERVATIVE_TTA = ...
    MODEL_REALCUGAN_PRO_UP3X_DENOISE3X_TTA      : sr_vulkan.MODEL.MODEL_REALCUGAN_PRO_UP3X_DENOISE3X_TTA    = ...
    MODEL_REALCUGAN_SE_UP2X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_TTA               = ...
    MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_CONSERVATIVE_TTA  = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE1X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE1X_TTA     = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE2X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE2X_TTA     = ...
    MODEL_REALCUGAN_SE_UP2X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP2X_DENOISE3X_TTA     = ...
    MODEL_REALCUGAN_SE_UP3X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_TTA               = ...
    MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_CONSERVATIVE_TTA  = ...
    MODEL_REALCUGAN_SE_UP3X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP3X_DENOISE3X_TTA     = ...
    MODEL_REALCUGAN_SE_UP4X_TTA                 : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_TTA               = ...
    MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE_TTA    : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_CONSERVATIVE_TTA  = ...
    MODEL_REALCUGAN_SE_UP4X_DENOISE3X_TTA       : sr_vulkan.MODEL.MODEL_REALCUGAN_SE_UP4X_DENOISE3X_TTA     = ...
    MODEL_REALSR_DF2K_UP4X_TTA                  : sr_vulkan.MODEL.MODEL_REALSR_DF2K_UP4X_TTA                = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP2X_TTA                    = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP3X_TTA                    = ...
    MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X_TTA          : sr_vulkan.MODEL.MODEL_REALESRGAN_ANIMAVIDEOV3_UP4X_TTA                    = ...
    MODEL_REALESRGAN_X4PLUS_UP4X_TTA                : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUS_UP4X_TTA                    = ...
    MODEL_REALESRGAN_X4PLUSANIME_UP4X_TTA           : sr_vulkan.MODEL.MODEL_REALESRGAN_X4PLUSANIME_UP4X_TTA                    = ...
_FORMAT = Literal["", "jpg", "jpeg", "png", "bmp", "webp", "apng"]

def init() -> int: ...
def getGpuInfo() -> Union[None, List[str]]: ...
def getGpuCoreNum(gpuId:int) -> int: ...
def getCpuCoreNum() -> int: ...
def initSet(gpuId:int, cpuNum:int=...) -> int: ...
@overload
def add(data:bytes, modelIndex: MODEL, backId:int, width:int, height:int, format:_FORMAT="", tileSize:int=400) -> int: ...
@overload
def add(data:bytes, modelIndex: MODEL, backId:int, scale:float, format:_FORMAT="", tileSize:int=400) -> int: ...
def getVersion() -> str: ...
def setDebug(bool) -> None: ...
def setWebpQuality(int) -> None: ...
def getLastError() -> str: ...
def remove(backIds:List[int]) -> None: ...
def removeWaitProc(backIds:List[int]) -> None: ...
def setModelPath(path: str) -> None: ...
def load(block:int) -> Union[None, Tuple]: ...
def stop() -> None: ...

# eof
