
option(USE_SYSTEM_NCNN "build with system libncnn" OFF)

if(USE_SYSTEM_NCNN)
    find_package(Threads)
    find_package(SPIRV-Tools QUIET)
    find_package(SPIRV-Tools-opt QUIET)
    find_package(glslang QUIET)
    if(glslang_FOUND)
        add_library(glslang ALIAS glslang::glslang)
        add_library(SPIRV ALIAS glslang::SPIRV)
    else()
        set(GLSLANG_TARGET_DIR "GLSLANG-NOTFOUND" CACHE PATH "Absolute path to glslangTargets.cmake directory")
        if(NOT GLSLANG_TARGET_DIR AND NOT DEFINED ENV{GLSLANG_TARGET_DIR})
            message(WARNING "set glslang_DIR to glslang-config.cmake directory for using system glslang.")
            message(WARNING "GLSLANG_TARGET_DIR must be defined! USE_SYSTEM_NCNN will be turned off.")
            set(USE_SYSTEM_NCNN OFF)
        else()
            include("${GLSLANG_TARGET_DIR}/OSDependentTargets.cmake")
            include("${GLSLANG_TARGET_DIR}/OGLCompilerTargets.cmake")
            if(EXISTS "${GLSLANG_TARGET_DIR}/HLSLTargets.cmake")
                # hlsl support can be optional
                include("${GLSLANG_TARGET_DIR}/HLSLTargets.cmake")
            endif()
            include("${GLSLANG_TARGET_DIR}/glslangTargets.cmake")
            include("${GLSLANG_TARGET_DIR}/SPIRVTargets.cmake")
        endif()
    endif()

    if(TARGET glslang AND TARGET SPIRV)
        get_property(glslang_location TARGET glslang PROPERTY LOCATION)
        get_property(SPIRV_location TARGET SPIRV PROPERTY LOCATION)
        message(STATUS "Found glslang: ${glslang_location} (found version \"${glslang_VERSION}\")")
        message(STATUS "Found SPIRV: ${SPIRV_location} (found version \"${glslang_VERSION}\")")
    else()
        message(WARNING "glslang or SPIRV target not found! USE_SYSTEM_NCNN will be turned off.")
        set(USE_SYSTEM_NCNN OFF)
    endif()
endif()

if(USE_SYSTEM_NCNN)
    find_package(ncnn)
    if(NOT TARGET ncnn)
        message(WARNING "ncnn target not found! USE_SYSTEM_NCNN will be turned off.")
        set(USE_SYSTEM_NCNN OFF)
    endif()
endif()

if(NOT USE_SYSTEM_NCNN)
    # build ncnn library
    if(NOT EXISTS "${CMAKE_CURRENT_SOURCE_DIR}/ncnn/CMakeLists.txt")
        message(FATAL_ERROR "The submodules were not downloaded! Please update submodules with \"git submodule update --init --recursive\" and try again.")
    endif()

    option(NCNN_INSTALL_SDK "" OFF)
    option(NCNN_PIXEL_ROTATE "" OFF)
    option(NCNN_PIXEL_AFFINE "" OFF)
    option(NCNN_PIXEL_DRAWING "" OFF)
    option(NCNN_VULKAN "" ON)
    option(NCNN_SIMPLEVK "" ON)
    option(NCNN_BUILD_BENCHMARK "" OFF)
    option(NCNN_BUILD_TESTS "" OFF)
    option(NCNN_BUILD_TOOLS "" OFF)
    option(NCNN_BUILD_EXAMPLES "" OFF)
    option(NCNN_DISABLE_RTTI "" ON)
    option(NCNN_DISABLE_EXCEPTION "" ON)
    option(NCNN_INT8 "" OFF)
	option(NCNN_BF16 "" OFF)

    option(WITH_LAYER_absval "" OFF)
    option(WITH_LAYER_argmax "" OFF)
    option(WITH_LAYER_batchnorm "" OFF)
    option(WITH_LAYER_bias "" OFF)
    option(WITH_LAYER_bnll "" OFF)
    option(WITH_LAYER_concat "" ON)
    option(WITH_LAYER_convolution "" ON)
    option(WITH_LAYER_crop "" ON)
    option(WITH_LAYER_deconvolution "" ON)
    option(WITH_LAYER_dropout "" OFF)
    option(WITH_LAYER_eltwise "" ON)
    option(WITH_LAYER_elu "" OFF)
    option(WITH_LAYER_embed "" OFF)
    option(WITH_LAYER_exp "" OFF)
    option(WITH_LAYER_flatten "" ON)
    option(WITH_LAYER_innerproduct "" ON)
    option(WITH_LAYER_input "" ON)
    option(WITH_LAYER_log "" OFF)
    option(WITH_LAYER_lrn "" OFF)
    option(WITH_LAYER_memorydata "" OFF)
    option(WITH_LAYER_mvn "" OFF)
    option(WITH_LAYER_pooling "" ON)
    option(WITH_LAYER_power "" OFF)
    option(WITH_LAYER_prelu "" ON)
    option(WITH_LAYER_proposal "" OFF)
    option(WITH_LAYER_reduction "" ON)
    option(WITH_LAYER_relu "" ON)
    option(WITH_LAYER_reshape "" OFF)
    option(WITH_LAYER_roipooling "" OFF)
    option(WITH_LAYER_scale "" ON)
    option(WITH_LAYER_sigmoid "" ON)
    option(WITH_LAYER_slice "" OFF)
    option(WITH_LAYER_softmax "" OFF)
    option(WITH_LAYER_split "" ON)
    option(WITH_LAYER_spp "" OFF)
    option(WITH_LAYER_tanh "" OFF)
    option(WITH_LAYER_threshold "" OFF)
    option(WITH_LAYER_tile "" OFF)
    option(WITH_LAYER_rnn "" OFF)
    option(WITH_LAYER_lstm "" OFF)
    option(WITH_LAYER_binaryop "" ON)
    option(WITH_LAYER_unaryop "" OFF)
    option(WITH_LAYER_convolutiondepthwise "" OFF)
    option(WITH_LAYER_padding "" ON)
    option(WITH_LAYER_squeeze "" OFF)
    option(WITH_LAYER_expanddims "" OFF)
    option(WITH_LAYER_normalize "" OFF)
    option(WITH_LAYER_permute "" OFF)
    option(WITH_LAYER_priorbox "" OFF)
    option(WITH_LAYER_detectionoutput "" OFF)
    option(WITH_LAYER_interp "" ON)
    option(WITH_LAYER_deconvolutiondepthwise "" OFF)
    option(WITH_LAYER_shufflechannel "" OFF)
    option(WITH_LAYER_instancenorm "" OFF)
    option(WITH_LAYER_clip "" OFF)
    option(WITH_LAYER_reorg "" OFF)
    option(WITH_LAYER_yolodetectionoutput "" OFF)
    option(WITH_LAYER_quantize "" OFF)
    option(WITH_LAYER_dequantize "" OFF)
    option(WITH_LAYER_yolov3detectionoutput "" OFF)
    option(WITH_LAYER_psroipooling "" OFF)
    option(WITH_LAYER_roialign "" OFF)
    option(WITH_LAYER_packing "" ON)
    option(WITH_LAYER_requantize "" OFF)
    option(WITH_LAYER_cast "" ON)
    option(WITH_LAYER_hardsigmoid "" OFF)
    option(WITH_LAYER_selu "" OFF)
    option(WITH_LAYER_hardswish "" OFF)
    option(WITH_LAYER_noop "" OFF)
    option(WITH_LAYER_pixelshuffle "" ON)
    option(WITH_LAYER_deepcopy "" OFF)
    option(WITH_LAYER_mish "" OFF)
    option(WITH_LAYER_statisticspooling "" OFF)
    option(WITH_LAYER_swish "" OFF)
    option(WITH_LAYER_gemm "" ON)
    option(WITH_LAYER_groupnorm "" OFF)
    option(WITH_LAYER_layernorm "" OFF)
    option(WITH_LAYER_softplus "" OFF)
    option(WITH_LAYER_gru "" OFF)
    option(WITH_LAYER_multiheadattention "" OFF)
    option(WITH_LAYER_gelu "" OFF)
    option(WITH_LAYER_convolution1d "" OFF)
    option(WITH_LAYER_pooling1d "" OFF)
    option(WITH_LAYER_convolutiondepthwise1d "" OFF)
    option(WITH_LAYER_convolution3d "" OFF)
    option(WITH_LAYER_convolutiondepthwise3d "" OFF)
    option(WITH_LAYER_pooling3d "" OFF)
    option(WITH_LAYER_matmul "" OFF)
    option(WITH_LAYER_deconvolution1d "" OFF)
    option(WITH_LAYER_deconvolutiondepthwise1d "" OFF)
    option(WITH_LAYER_deconvolution3d "" OFF)
    option(WITH_LAYER_deconvolutiondepthwise3d "" OFF)
    option(WITH_LAYER_einsum "" OFF)
    option(WITH_LAYER_deformableconv2d "" OFF)
	option(WITH_LAYER_glu "" OFF)
    option(WITH_LAYER_fold "" OFF)
    option(WITH_LAYER_unfold "" OFF)
    option(WITH_LAYER_gridsample "" OFF)
    option(WITH_LAYER_cumulativesum "" OFF)
    option(WITH_LAYER_copyto "" OFF)
    option(WITH_LAYER_erf "" OFF)
    option(WITH_LAYER_diag "" OFF)
    option(WITH_LAYER_celu "" OFF)
    option(WITH_LAYER_shrink "" OFF)
    option(WITH_LAYER_rmsnorm "" OFF)
    option(WITH_LAYER_spectrogram "" OFF)
    option(WITH_LAYER_inversespectrogram "" OFF)

    add_subdirectory(ncnn)
endif()
