// Copyright 2021 Tencent
// SPDX-License-Identifier: BSD-3-Clause

#include "pass_level2.h"

namespace pnnx {

class F_threshold : public GraphRewriterPass
{
public:
    const char* match_pattern_graph() const
    {
        return R"PNNXIR(7767517
5 4
pnnx.Input              input_0     0 1 input
pnnx.Input              input_1     0 1 threshold
pnnx.Input              input_2     0 1 value
aten::threshold         op_0        3 1 input threshold value out
pnnx.Output             output      1 0 out
)PNNXIR";
    }

    const char* type_str() const
    {
        return "F.threshold";
    }
};

REGISTER_GLOBAL_PNNX_GRAPH_REWRITER_PASS(F_threshold, 100)

} // namespace pnnx
