# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.agent_prompts_response import AgentPromptsResponse
from ..types.json_patch import JsonPatch
from ..types.success_response import SuccessResponse
from .raw_client import AsyncRawPromptsClient, RawPromptsClient
from .types.prompts_delete_response import PromptsDeleteResponse
from .types.prompts_list_response import PromptsListResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PromptsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPromptsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        name: str,
        content: str,
        is_active: bool,
        description: typing.Optional[str] = OMIT,
        is_default: typing.Optional[bool] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentPromptsResponse:
        """
        Creates a new agent prompt

        Parameters
        ----------
        name : str
            Prompt name

        content : str
            Prompt content

        is_active : bool
            Whether the prompt is active

        description : typing.Optional[str]
            Prompt description

        is_default : typing.Optional[bool]
            Whether this is a default prompt

        tags : typing.Optional[typing.Sequence[str]]
            Tags for categorizing the prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt created successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.create(
            name="Medical Assistant System Prompt",
            content="You are a helpful medical assistant specialized in FHIR data processing...",
            is_active=True,
        )
        """
        _response = self._raw_client.create(
            name=name,
            content=content,
            is_active=is_active,
            description=description,
            is_default=is_default,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> PromptsListResponse:
        """
        Retrieves a list of agent prompts belonging to the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptsListResponse
            Prompts retrieved successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AgentPromptsResponse:
        """
        Retrieves a specific prompt by its ID

        Parameters
        ----------
        id : str
            Prompt ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt retrieved successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.get(
            id="id",
        )
        """
        _response = self._raw_client.get(id, request_options=request_options)
        return _response.data

    def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        content: typing.Optional[str] = OMIT,
        is_default: typing.Optional[bool] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentPromptsResponse:
        """
        Updates an existing prompt

        Parameters
        ----------
        id : str
            Prompt ID

        name : typing.Optional[str]
            Prompt name

        description : typing.Optional[str]
            Prompt description

        content : typing.Optional[str]
            Prompt content

        is_default : typing.Optional[bool]
            Whether this is a default prompt

        is_active : typing.Optional[bool]
            Whether the prompt is active

        tags : typing.Optional[typing.Sequence[str]]
            Tags for categorizing the prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt updated successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.update(
            id="id",
        )
        """
        _response = self._raw_client.update(
            id,
            name=name,
            description=description,
            content=content,
            is_default=is_default,
            is_active=is_active,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    def delete(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> PromptsDeleteResponse:
        """
        Soft deletes a prompt by setting is_active to false

        Parameters
        ----------
        id : str
            Prompt ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptsDeleteResponse
            Prompt deleted successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.delete(
            id="id",
        )
        """
        _response = self._raw_client.delete(id, request_options=request_options)
        return _response.data

    def patch(
        self, id: str, *, request: JsonPatch, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentPromptsResponse:
        """
        Patches an existing prompt

        Parameters
        ----------
        id : str
            Agent Prompt ID

        request : JsonPatch

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt patched successfully

        Examples
        --------
        from phenoml import phenoml
        from phenoml.agent import JsonPatchOperation

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.patch(
            id="id",
            request=[
                JsonPatchOperation(
                    op="replace",
                    path="/name",
                    value="Updated Agent Name",
                ),
                JsonPatchOperation(
                    op="add",
                    path="/tags/-",
                    value="new-tag",
                ),
                JsonPatchOperation(
                    op="remove",
                    path="/description",
                ),
            ],
        )
        """
        _response = self._raw_client.patch(id, request=request, request_options=request_options)
        return _response.data

    def load_defaults(self, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Loads default agent prompts for the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Default prompts loaded successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.agent.prompts.load_defaults()
        """
        _response = self._raw_client.load_defaults(request_options=request_options)
        return _response.data


class AsyncPromptsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPromptsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPromptsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPromptsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        name: str,
        content: str,
        is_active: bool,
        description: typing.Optional[str] = OMIT,
        is_default: typing.Optional[bool] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentPromptsResponse:
        """
        Creates a new agent prompt

        Parameters
        ----------
        name : str
            Prompt name

        content : str
            Prompt content

        is_active : bool
            Whether the prompt is active

        description : typing.Optional[str]
            Prompt description

        is_default : typing.Optional[bool]
            Whether this is a default prompt

        tags : typing.Optional[typing.Sequence[str]]
            Tags for categorizing the prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt created successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.create(
                name="Medical Assistant System Prompt",
                content="You are a helpful medical assistant specialized in FHIR data processing...",
                is_active=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            content=content,
            is_active=is_active,
            description=description,
            is_default=is_default,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> PromptsListResponse:
        """
        Retrieves a list of agent prompts belonging to the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptsListResponse
            Prompts retrieved successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def get(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> AgentPromptsResponse:
        """
        Retrieves a specific prompt by its ID

        Parameters
        ----------
        id : str
            Prompt ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt retrieved successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.get(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(id, request_options=request_options)
        return _response.data

    async def update(
        self,
        id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        content: typing.Optional[str] = OMIT,
        is_default: typing.Optional[bool] = OMIT,
        is_active: typing.Optional[bool] = OMIT,
        tags: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AgentPromptsResponse:
        """
        Updates an existing prompt

        Parameters
        ----------
        id : str
            Prompt ID

        name : typing.Optional[str]
            Prompt name

        description : typing.Optional[str]
            Prompt description

        content : typing.Optional[str]
            Prompt content

        is_default : typing.Optional[bool]
            Whether this is a default prompt

        is_active : typing.Optional[bool]
            Whether the prompt is active

        tags : typing.Optional[typing.Sequence[str]]
            Tags for categorizing the prompt

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt updated successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.update(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            id,
            name=name,
            description=description,
            content=content,
            is_default=is_default,
            is_active=is_active,
            tags=tags,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PromptsDeleteResponse:
        """
        Soft deletes a prompt by setting is_active to false

        Parameters
        ----------
        id : str
            Prompt ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PromptsDeleteResponse
            Prompt deleted successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.delete(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(id, request_options=request_options)
        return _response.data

    async def patch(
        self, id: str, *, request: JsonPatch, request_options: typing.Optional[RequestOptions] = None
    ) -> AgentPromptsResponse:
        """
        Patches an existing prompt

        Parameters
        ----------
        id : str
            Agent Prompt ID

        request : JsonPatch

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AgentPromptsResponse
            Prompt patched successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml
        from phenoml.agent import JsonPatchOperation

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.patch(
                id="id",
                request=[
                    JsonPatchOperation(
                        op="replace",
                        path="/name",
                        value="Updated Agent Name",
                    ),
                    JsonPatchOperation(
                        op="add",
                        path="/tags/-",
                        value="new-tag",
                    ),
                    JsonPatchOperation(
                        op="remove",
                        path="/description",
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(id, request=request, request_options=request_options)
        return _response.data

    async def load_defaults(self, *, request_options: typing.Optional[RequestOptions] = None) -> SuccessResponse:
        """
        Loads default agent prompts for the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResponse
            Default prompts loaded successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.agent.prompts.load_defaults()


        asyncio.run(main())
        """
        _response = await self._raw_client.load_defaults(request_options=request_options)
        return _response.data
