# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .agent_create_request_provider import AgentCreateRequestProvider


class AgentCreateRequest(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    Agent name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent description
    """

    prompts: typing.List[str] = pydantic.Field()
    """
    Array of prompt IDs to use for this agent
    """

    tools: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Array of MCP server tool IDs to use for this agent
    """

    is_active: bool = pydantic.Field()
    """
    Whether the agent is active
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Tags for categorizing the agent
    """

    provider: typing.Optional[AgentCreateRequestProvider] = pydantic.Field(default=None)
    """
    FHIR provider ID(s) - must be valid UUIDs from existing FHIR providers
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
