# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .agent_template_provider import AgentTemplateProvider


class AgentTemplate(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent ID
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Agent description
    """

    prompts: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Array of prompt IDs used by this agent
    """

    tools: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Array of MCP server tool IDs used by this agent
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the agent is active
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Tags for categorizing the agent
    """

    provider: typing.Optional[AgentTemplateProvider] = pydantic.Field(default=None)
    """
    FHIR provider ID(s) - must be valid UUIDs from existing FHIR providers
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
