# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ChatMessageTemplate(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Chat message ID
    """

    session_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Chat session ID
    """

    role: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message role
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message content
    """

    created: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message created time
    """

    updated: typing.Optional[str] = pydantic.Field(default=None)
    """
    Message updated time
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    User ID
    """

    function_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Function name
    """

    function_args: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Function arguments
    """

    function_result: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Function result
    """

    message_order: typing.Optional[int] = pydantic.Field(default=None)
    """
    Message order
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
