# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .json_patch_operation_op import JsonPatchOperationOp


class JsonPatchOperation(UniversalBaseModel):
    op: JsonPatchOperationOp = pydantic.Field()
    """
    The operation to be performed
    """

    path: str = pydantic.Field()
    """
    A JSON Pointer string specifying a location within the target document
    """

    value: typing.Optional[typing.Optional[typing.Any]] = None
    from_: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="from")] = pydantic.Field(default=None)
    """
    A JSON Pointer string specifying the location in the target document to move the value from (used with move and copy operations)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
