# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class PromptTemplate(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt ID
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt name
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt description
    """

    content: typing.Optional[str] = pydantic.Field(default=None)
    """
    Prompt content
    """

    is_default: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this is a default prompt
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the prompt is active
    """

    tags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Tags for categorizing the prompt
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
