# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawAuthClient, RawAuthClient
from .types.auth_generate_token_response import AuthGenerateTokenResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AuthClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAuthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAuthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAuthClient
        """
        return self._raw_client

    def generate_token(
        self, *, username: str, password: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthGenerateTokenResponse:
        """
        Obtain an access token using client credentials

        Parameters
        ----------
        username : str
            The user's username or email

        password : str
            The user's password

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthGenerateTokenResponse
            Successfully generated token

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.authtoken.auth.generate_token(
            username="username",
            password="password",
        )
        """
        _response = self._raw_client.generate_token(
            username=username, password=password, request_options=request_options
        )
        return _response.data


class AsyncAuthClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAuthClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAuthClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAuthClient
        """
        return self._raw_client

    async def generate_token(
        self, *, username: str, password: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthGenerateTokenResponse:
        """
        Obtain an access token using client credentials

        Parameters
        ----------
        username : str
            The user's username or email

        password : str
            The user's password

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthGenerateTokenResponse
            Successfully generated token

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.authtoken.auth.generate_token(
                username="username",
                password="password",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.generate_token(
            username=username, password=password, request_options=request_options
        )
        return _response.data
