# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawCohortClient, RawCohortClient
from .types.cohort_response import CohortResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CohortClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCohortClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCohortClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCohortClient
        """
        return self._raw_client

    def analyze(self, *, text: str, request_options: typing.Optional[RequestOptions] = None) -> CohortResponse:
        """
        Converts natural language text into structured FHIR search queries for patient cohort analysis

        Parameters
        ----------
        text : str
            Natural language text describing patient cohort criteria

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CohortResponse
            Successfully analyzed cohort criteria

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.cohort.analyze(
            text="female patients over 65 with diabetes but not hypertension",
        )
        """
        _response = self._raw_client.analyze(text=text, request_options=request_options)
        return _response.data


class AsyncCohortClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCohortClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCohortClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCohortClient
        """
        return self._raw_client

    async def analyze(self, *, text: str, request_options: typing.Optional[RequestOptions] = None) -> CohortResponse:
        """
        Converts natural language text into structured FHIR search queries for patient cohort analysis

        Parameters
        ----------
        text : str
            Natural language text describing patient cohort criteria

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CohortResponse
            Successfully analyzed cohort criteria

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.cohort.analyze(
                text="female patients over 65 with diabetes but not hypertension",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.analyze(text=text, request_options=request_options)
        return _response.data
