# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SearchConcept(UniversalBaseModel):
    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The FHIR resource type for this search concept
    """

    search_params: typing.Optional[str] = pydantic.Field(default=None)
    """
    FHIR search parameters in standard format
    """

    concept: typing.Optional[str] = pydantic.Field(default=None)
    """
    The original concept description
    """

    exclude: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this concept should be excluded from the search
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
