# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawConstrueClient, RawConstrueClient
from .types.construe_cohort_request_config import ConstrueCohortRequestConfig
from .types.construe_cohort_response import ConstrueCohortResponse
from .types.construe_upload_code_system_response import ConstrueUploadCodeSystemResponse
from .types.extract_codes_result import ExtractCodesResult
from .types.extract_request_config import ExtractRequestConfig
from .types.extract_request_system import ExtractRequestSystem
from .types.upload_request_format import UploadRequestFormat

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ConstrueClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawConstrueClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawConstrueClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawConstrueClient
        """
        return self._raw_client

    def upload_code_system(
        self,
        *,
        name: str,
        version: str,
        format: UploadRequestFormat,
        file: str,
        revision: typing.Optional[float] = OMIT,
        code_col: typing.Optional[str] = OMIT,
        desc_col: typing.Optional[str] = OMIT,
        defn_col: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConstrueUploadCodeSystemResponse:
        """
        Upload a custom medical code system with codes and descriptions for use in code extraction.
        Upon upload, construe generates embeddings for all of the codes in the code system and stores them in the vector database so you can
        subsequently use the code system for construe/extract and lang2fhir/create (coming soon!)

        Parameters
        ----------
        name : str
            Name of the code system

        version : str
            Version of the code system

        format : UploadRequestFormat
            Format of the uploaded file

        file : str
            The file contents as a base64-encoded string

        revision : typing.Optional[float]
            Optional revision number

        code_col : typing.Optional[str]
            Column name containing codes (required for CSV format)

        desc_col : typing.Optional[str]
            Column name containing descriptions (required for CSV format)

        defn_col : typing.Optional[str]
            Optional column name containing long definitions (for CSV format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConstrueUploadCodeSystemResponse
            Successfully uploaded code system

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.construe.upload_code_system(
            name="CUSTOM_CODES",
            version="1.0",
            format="json",
            file="file",
        )
        """
        _response = self._raw_client.upload_code_system(
            name=name,
            version=version,
            format=format,
            file=file,
            revision=revision,
            code_col=code_col,
            desc_col=desc_col,
            defn_col=defn_col,
            request_options=request_options,
        )
        return _response.data

    def extract_codes(
        self,
        *,
        text: str,
        system: typing.Optional[ExtractRequestSystem] = OMIT,
        config: typing.Optional[ExtractRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractCodesResult:
        """
        Converts natural language text into structured medical codes

        Parameters
        ----------
        text : str
            Natural language text to extract codes from

        system : typing.Optional[ExtractRequestSystem]

        config : typing.Optional[ExtractRequestConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractCodesResult
            Successfully extracted codes

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.construe.extract_codes(
            text="Patient is a 14-year-old female, previously healthy, who is here for evaluation of abnormal renal ultrasound with atrophic right kidney",
        )
        """
        _response = self._raw_client.extract_codes(
            text=text, system=system, config=config, request_options=request_options
        )
        return _response.data

    def cohort(
        self,
        *,
        text: str,
        config: typing.Optional[ConstrueCohortRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConstrueCohortResponse:
        """
        Creates a patient cohort based on a natural language description.
        Translates the description into FHIR search queries and optional SQL queries.

        Parameters
        ----------
        text : str
            Natural language description of the desired patient cohort.

        config : typing.Optional[ConstrueCohortRequestConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConstrueCohortResponse
            Cohort creation successful

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.construe.cohort(
            text="Between 20 and 40 years old with hyperlipidemia",
        )
        """
        _response = self._raw_client.cohort(text=text, config=config, request_options=request_options)
        return _response.data


class AsyncConstrueClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawConstrueClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawConstrueClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawConstrueClient
        """
        return self._raw_client

    async def upload_code_system(
        self,
        *,
        name: str,
        version: str,
        format: UploadRequestFormat,
        file: str,
        revision: typing.Optional[float] = OMIT,
        code_col: typing.Optional[str] = OMIT,
        desc_col: typing.Optional[str] = OMIT,
        defn_col: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConstrueUploadCodeSystemResponse:
        """
        Upload a custom medical code system with codes and descriptions for use in code extraction.
        Upon upload, construe generates embeddings for all of the codes in the code system and stores them in the vector database so you can
        subsequently use the code system for construe/extract and lang2fhir/create (coming soon!)

        Parameters
        ----------
        name : str
            Name of the code system

        version : str
            Version of the code system

        format : UploadRequestFormat
            Format of the uploaded file

        file : str
            The file contents as a base64-encoded string

        revision : typing.Optional[float]
            Optional revision number

        code_col : typing.Optional[str]
            Column name containing codes (required for CSV format)

        desc_col : typing.Optional[str]
            Column name containing descriptions (required for CSV format)

        defn_col : typing.Optional[str]
            Optional column name containing long definitions (for CSV format)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConstrueUploadCodeSystemResponse
            Successfully uploaded code system

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.construe.upload_code_system(
                name="CUSTOM_CODES",
                version="1.0",
                format="json",
                file="file",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload_code_system(
            name=name,
            version=version,
            format=format,
            file=file,
            revision=revision,
            code_col=code_col,
            desc_col=desc_col,
            defn_col=defn_col,
            request_options=request_options,
        )
        return _response.data

    async def extract_codes(
        self,
        *,
        text: str,
        system: typing.Optional[ExtractRequestSystem] = OMIT,
        config: typing.Optional[ExtractRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExtractCodesResult:
        """
        Converts natural language text into structured medical codes

        Parameters
        ----------
        text : str
            Natural language text to extract codes from

        system : typing.Optional[ExtractRequestSystem]

        config : typing.Optional[ExtractRequestConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExtractCodesResult
            Successfully extracted codes

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.construe.extract_codes(
                text="Patient is a 14-year-old female, previously healthy, who is here for evaluation of abnormal renal ultrasound with atrophic right kidney",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.extract_codes(
            text=text, system=system, config=config, request_options=request_options
        )
        return _response.data

    async def cohort(
        self,
        *,
        text: str,
        config: typing.Optional[ConstrueCohortRequestConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ConstrueCohortResponse:
        """
        Creates a patient cohort based on a natural language description.
        Translates the description into FHIR search queries and optional SQL queries.

        Parameters
        ----------
        text : str
            Natural language description of the desired patient cohort.

        config : typing.Optional[ConstrueCohortRequestConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ConstrueCohortResponse
            Cohort creation successful

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.construe.cohort(
                text="Between 20 and 40 years old with hyperlipidemia",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cohort(text=text, config=config, request_options=request_options)
        return _response.data
