# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class ExtractRequestSystem(UniversalBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Code system name. Can be a built-in system or a custom system name.
    
    Built-in systems:
    * SNOMED_CT_US_LITE - version 20240901
    * RXNORM - version 11042024
    * ICD-10-CM - version 2025
    * ICD-10-PCS - version 2025
    * LOINC - version 2.78
    
    Custom systems:
    * Any valid system name configured in your environment. Must have self-hosted construe module.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    Code system version. Must match the version available in your environment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
