# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class ExtractedCodeResult(UniversalBaseModel):
    code: str = pydantic.Field()
    """
    The extracted code
    """

    description: str = pydantic.Field()
    """
    Short description of the code
    """

    long_description: typing_extensions.Annotated[typing.Optional[str], FieldMetadata(alias="longDescription")] = (
        pydantic.Field(default=None)
    )
    """
    Long description of the code
    """

    rationale: typing.Optional[str] = pydantic.Field(default=None)
    """
    Explanation for why this code was extracted (if include_rationale is true)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
