# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawFhirClient, RawFhirClient
from .types.fhir_bundle import FhirBundle
from .types.fhir_bundle_entry_item import FhirBundleEntryItem
from .types.fhir_patch_request_body_item import FhirPatchRequestBodyItem
from .types.fhir_resource import FhirResource
from .types.fhir_resource_meta import FhirResourceMeta
from .types.fhir_search_response import FhirSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FhirClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFhirClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFhirClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFhirClient
        """
        return self._raw_client

    def search(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        query_parameters: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirSearchResponse:
        """
        Retrieves FHIR resources from the specified provider. Supports both individual resource retrieval and search operations based on the FHIR path and query parameters.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        query_parameters : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            FHIR-compliant query parameters for search operations. Supports standard FHIR search parameters including:
            - Resource-specific search parameters (e.g., name for Patient, status for Observation)
            - Common search parameters (_id, _lastUpdated, _tag, _profile, _security, _text, _content, _filter)
            - Result parameters (_count, _offset, _sort, _include, _revinclude, _summary, _elements)
            - Search prefixes for dates, numbers, quantities (eq, ne, gt, ge, lt, le, sa, eb, ap)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirSearchResponse
            Successfully retrieved FHIR resource(s)

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.search(
            fhir_provider_id="fhir_provider_id",
            fhir_path="fhir_path",
            phenoml_on_behalf_of="user@example.com",
        )
        """
        _response = self._raw_client.search(
            fhir_provider_id,
            fhir_path,
            query_parameters=query_parameters,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        resource_type: str,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        id: typing.Optional[str] = OMIT,
        meta: typing.Optional[FhirResourceMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Creates a new FHIR resource on the specified provider. The request body should contain a valid FHIR resource in JSON format.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        resource_type : str
            The type of FHIR resource (e.g., Patient, Observation, etc.)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        id : typing.Optional[str]
            Logical ID of the resource

        meta : typing.Optional[FhirResourceMeta]
            Metadata about the resource

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource created successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.create(
            fhir_provider_id="fhir_provider_id",
            fhir_path="fhir_path",
            phenoml_on_behalf_of="user@example.com",
            resource_type="Patient",
        )
        """
        _response = self._raw_client.create(
            fhir_provider_id,
            fhir_path,
            resource_type=resource_type,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            id=id,
            meta=meta,
            request_options=request_options,
        )
        return _response.data

    def upsert(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        resource_type: str,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        id: typing.Optional[str] = OMIT,
        meta: typing.Optional[FhirResourceMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Creates or updates a FHIR resource on the specified provider. If the resource exists, it will be updated; otherwise, it will be created.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        resource_type : str
            The type of FHIR resource (e.g., Patient, Observation, etc.)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        id : typing.Optional[str]
            Logical ID of the resource

        meta : typing.Optional[FhirResourceMeta]
            Metadata about the resource

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource upserted successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.upsert(
            fhir_provider_id="fhir_provider_id",
            fhir_path="fhir_path",
            phenoml_on_behalf_of="user@example.com",
            resource_type="Patient",
            id="123",
        )
        """
        _response = self._raw_client.upsert(
            fhir_provider_id,
            fhir_path,
            resource_type=resource_type,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            id=id,
            meta=meta,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Deletes a FHIR resource from the specified provider.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Resource deleted successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.delete(
            fhir_provider_id="fhir_provider_id",
            fhir_path="fhir_path",
            phenoml_on_behalf_of="user@example.com",
        )
        """
        _response = self._raw_client.delete(
            fhir_provider_id, fhir_path, phenoml_on_behalf_of=phenoml_on_behalf_of, request_options=request_options
        )
        return _response.data

    def patch(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        request: typing.Sequence[FhirPatchRequestBodyItem],
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Partially updates a FHIR resource on the specified provider using JSON Patch operations as defined in RFC 6902.

        The request body should contain an array of JSON Patch operations. Each operation specifies:
        - `op`: The operation type (add, remove, replace, move, copy, test)
        - `path`: JSON Pointer to the target location in the resource
        - `value`: The value to use (required for add, replace, and test operations)

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        request : typing.Sequence[FhirPatchRequestBodyItem]

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource patched successfully

        Examples
        --------
        from phenoml import phenoml
        from phenoml.fhir import FhirPatchRequestBodyItem

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.patch(
            fhir_provider_id="fhir_provider_id",
            fhir_path="fhir_path",
            phenoml_on_behalf_of="user@example.com",
            request=[
                FhirPatchRequestBodyItem(
                    op="replace",
                    path="/name/0/family",
                    value="NewFamilyName",
                )
            ],
        )
        """
        _response = self._raw_client.patch(
            fhir_provider_id,
            fhir_path,
            request=request,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            request_options=request_options,
        )
        return _response.data

    def execute_bundle(
        self,
        fhir_provider_id: str,
        *,
        entry: typing.Sequence[FhirBundleEntryItem],
        phenoml_on_behalf_of: typing.Optional[str] = None,
        total: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirBundle:
        """
        Executes a FHIR Bundle transaction or batch operation on the specified provider. This allows multiple FHIR resources to be processed in a single request.

        The request body should contain a valid FHIR Bundle resource with transaction or batch type.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        entry : typing.Sequence[FhirBundleEntryItem]
            Array of bundle entries containing resources or operation results

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        total : typing.Optional[int]
            Total number of resources that match the search criteria.
            Optional field as not all FHIR servers include it (e.g., Medplum).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirBundle
            Bundle executed successfully

        Examples
        --------
        from phenoml import phenoml
        from phenoml.fhir import FhirBundleEntryItem, FhirBundleEntryItemRequest

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir.execute_bundle(
            fhir_provider_id="fhir_provider_id",
            phenoml_on_behalf_of="user@example.com",
            entry=[
                FhirBundleEntryItem(
                    resource={
                        "resourceType": "Patient",
                        "name": [{"family": "Doe", "given": ["John"]}],
                    },
                    request=FhirBundleEntryItemRequest(
                        method="POST",
                        url="Patient",
                    ),
                ),
                FhirBundleEntryItem(
                    resource={
                        "resourceType": "Observation",
                        "status": "final",
                        "subject": {"reference": "Patient/123"},
                    },
                    request=FhirBundleEntryItemRequest(
                        method="POST",
                        url="Observation",
                    ),
                ),
            ],
        )
        """
        _response = self._raw_client.execute_bundle(
            fhir_provider_id,
            entry=entry,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            total=total,
            request_options=request_options,
        )
        return _response.data


class AsyncFhirClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFhirClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFhirClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFhirClient
        """
        return self._raw_client

    async def search(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        query_parameters: typing.Optional[typing.Dict[str, typing.Optional[str]]] = None,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirSearchResponse:
        """
        Retrieves FHIR resources from the specified provider. Supports both individual resource retrieval and search operations based on the FHIR path and query parameters.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        query_parameters : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            FHIR-compliant query parameters for search operations. Supports standard FHIR search parameters including:
            - Resource-specific search parameters (e.g., name for Patient, status for Observation)
            - Common search parameters (_id, _lastUpdated, _tag, _profile, _security, _text, _content, _filter)
            - Result parameters (_count, _offset, _sort, _include, _revinclude, _summary, _elements)
            - Search prefixes for dates, numbers, quantities (eq, ne, gt, ge, lt, le, sa, eb, ap)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirSearchResponse
            Successfully retrieved FHIR resource(s)

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.search(
                fhir_provider_id="fhir_provider_id",
                fhir_path="fhir_path",
                phenoml_on_behalf_of="user@example.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            fhir_provider_id,
            fhir_path,
            query_parameters=query_parameters,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        resource_type: str,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        id: typing.Optional[str] = OMIT,
        meta: typing.Optional[FhirResourceMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Creates a new FHIR resource on the specified provider. The request body should contain a valid FHIR resource in JSON format.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        resource_type : str
            The type of FHIR resource (e.g., Patient, Observation, etc.)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        id : typing.Optional[str]
            Logical ID of the resource

        meta : typing.Optional[FhirResourceMeta]
            Metadata about the resource

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource created successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.create(
                fhir_provider_id="fhir_provider_id",
                fhir_path="fhir_path",
                phenoml_on_behalf_of="user@example.com",
                resource_type="Patient",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            fhir_provider_id,
            fhir_path,
            resource_type=resource_type,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            id=id,
            meta=meta,
            request_options=request_options,
        )
        return _response.data

    async def upsert(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        resource_type: str,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        id: typing.Optional[str] = OMIT,
        meta: typing.Optional[FhirResourceMeta] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Creates or updates a FHIR resource on the specified provider. If the resource exists, it will be updated; otherwise, it will be created.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        resource_type : str
            The type of FHIR resource (e.g., Patient, Observation, etc.)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        id : typing.Optional[str]
            Logical ID of the resource

        meta : typing.Optional[FhirResourceMeta]
            Metadata about the resource

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource upserted successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.upsert(
                fhir_provider_id="fhir_provider_id",
                fhir_path="fhir_path",
                phenoml_on_behalf_of="user@example.com",
                resource_type="Patient",
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upsert(
            fhir_provider_id,
            fhir_path,
            resource_type=resource_type,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            id=id,
            meta=meta,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Deletes a FHIR resource from the specified provider.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Resource deleted successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.delete(
                fhir_provider_id="fhir_provider_id",
                fhir_path="fhir_path",
                phenoml_on_behalf_of="user@example.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(
            fhir_provider_id, fhir_path, phenoml_on_behalf_of=phenoml_on_behalf_of, request_options=request_options
        )
        return _response.data

    async def patch(
        self,
        fhir_provider_id: str,
        fhir_path: str,
        *,
        request: typing.Sequence[FhirPatchRequestBodyItem],
        phenoml_on_behalf_of: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Partially updates a FHIR resource on the specified provider using JSON Patch operations as defined in RFC 6902.

        The request body should contain an array of JSON Patch operations. Each operation specifies:
        - `op`: The operation type (add, remove, replace, move, copy, test)
        - `path`: JSON Pointer to the target location in the resource
        - `value`: The value to use (required for add, replace, and test operations)

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        fhir_path : str
            The FHIR resource path to operate on. This follows FHIR RESTful API conventions.
            Examples:
            - "Patient" (for resource type operations)
            - "Patient/123" (for specific resource operations)
            - "Patient/123/_history" (for history operations)

        request : typing.Sequence[FhirPatchRequestBodyItem]

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Resource patched successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml
        from phenoml.fhir import FhirPatchRequestBodyItem

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.patch(
                fhir_provider_id="fhir_provider_id",
                fhir_path="fhir_path",
                phenoml_on_behalf_of="user@example.com",
                request=[
                    FhirPatchRequestBodyItem(
                        op="replace",
                        path="/name/0/family",
                        value="NewFamilyName",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            fhir_provider_id,
            fhir_path,
            request=request,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            request_options=request_options,
        )
        return _response.data

    async def execute_bundle(
        self,
        fhir_provider_id: str,
        *,
        entry: typing.Sequence[FhirBundleEntryItem],
        phenoml_on_behalf_of: typing.Optional[str] = None,
        total: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirBundle:
        """
        Executes a FHIR Bundle transaction or batch operation on the specified provider. This allows multiple FHIR resources to be processed in a single request.

        The request body should contain a valid FHIR Bundle resource with transaction or batch type.

        The request is proxied to the configured FHIR server with appropriate authentication headers.

        Parameters
        ----------
        fhir_provider_id : str
            The ID of the FHIR provider to use. Can be either:
            - A UUID representing the provider ID
            - A provider name (legacy support - will just use the most recently updated provider with this name)

        entry : typing.Sequence[FhirBundleEntryItem]
            Array of bundle entries containing resources or operation results

        phenoml_on_behalf_of : typing.Optional[str]
            Optional header for on-behalf-of authentication. Used when making requests on behalf of another user or entity.

        total : typing.Optional[int]
            Total number of resources that match the search criteria.
            Optional field as not all FHIR servers include it (e.g., Medplum).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirBundle
            Bundle executed successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml
        from phenoml.fhir import FhirBundleEntryItem, FhirBundleEntryItemRequest

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir.execute_bundle(
                fhir_provider_id="fhir_provider_id",
                phenoml_on_behalf_of="user@example.com",
                entry=[
                    FhirBundleEntryItem(
                        resource={
                            "resourceType": "Patient",
                            "name": [{"family": "Doe", "given": ["John"]}],
                        },
                        request=FhirBundleEntryItemRequest(
                            method="POST",
                            url="Patient",
                        ),
                    ),
                    FhirBundleEntryItem(
                        resource={
                            "resourceType": "Observation",
                            "status": "final",
                            "subject": {"reference": "Patient/123"},
                        },
                        request=FhirBundleEntryItemRequest(
                            method="POST",
                            url="Observation",
                        ),
                    ),
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.execute_bundle(
            fhir_provider_id,
            entry=entry,
            phenoml_on_behalf_of=phenoml_on_behalf_of,
            total=total,
            request_options=request_options,
        )
        return _response.data
