# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .fhir_bundle_entry_item import FhirBundleEntryItem


class FhirBundle(UniversalBaseModel):
    """
    Represents a FHIR Bundle response containing multiple resources or operation results.
    Based on the FHIRBundle struct from io/fhir.go.
    """

    resource_type: typing_extensions.Annotated[typing.Literal["Bundle"], FieldMetadata(alias="resourceType")] = (
        pydantic.Field(default="Bundle")
    )
    """
    Always "Bundle" for bundle resources
    """

    total: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of resources that match the search criteria.
    Optional field as not all FHIR servers include it (e.g., Medplum).
    """

    entry: typing.List[FhirBundleEntryItem] = pydantic.Field()
    """
    Array of bundle entries containing resources or operation results
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
