# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .fhir_bundle_entry_item_request import FhirBundleEntryItemRequest
from .fhir_bundle_entry_item_response import FhirBundleEntryItemResponse


class FhirBundleEntryItem(UniversalBaseModel):
    resource: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    The FHIR resource contained in this entry
    """

    request: typing.Optional[FhirBundleEntryItemRequest] = pydantic.Field(default=None)
    """
    Request information for transaction/batch bundles
    """

    response: typing.Optional[FhirBundleEntryItemResponse] = pydantic.Field(default=None)
    """
    Response information for transaction/batch bundle responses
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
