# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .fhir_resource_meta import FhirResourceMeta


class FhirResource(UniversalBaseModel):
    """
    A generic FHIR resource. All FHIR resources share common elements like resourceType and id,
    but the specific structure depends on the resource type.
    """

    resource_type: typing_extensions.Annotated[str, FieldMetadata(alias="resourceType")] = pydantic.Field()
    """
    The type of FHIR resource (e.g., Patient, Observation, etc.)
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Logical ID of the resource
    """

    meta: typing.Optional[FhirResourceMeta] = pydantic.Field(default=None)
    """
    Metadata about the resource
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
