# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawFhirProviderClient, RawFhirProviderClient
from .types.auth_method import AuthMethod
from .types.fhir_provider_delete_response import FhirProviderDeleteResponse
from .types.fhir_provider_list_response import FhirProviderListResponse
from .types.fhir_provider_remove_auth_config_response import FhirProviderRemoveAuthConfigResponse
from .types.fhir_provider_response import FhirProviderResponse
from .types.fhir_provider_set_active_auth_config_response import FhirProviderSetActiveAuthConfigResponse
from .types.provider import Provider
from .types.service_account_key import ServiceAccountKey

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class FhirProviderClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFhirProviderClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFhirProviderClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFhirProviderClient
        """
        return self._raw_client

    def create(
        self,
        *,
        name: str,
        provider: Provider,
        auth_method: AuthMethod,
        base_url: str,
        description: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        service_account_key: typing.Optional[ServiceAccountKey] = OMIT,
        scopes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirProviderResponse:
        """
        Creates a new FHIR provider configuration with authentication credentials

        Parameters
        ----------
        name : str
            Display name for the FHIR provider

        provider : Provider

        auth_method : AuthMethod

        base_url : str
            Base URL of the FHIR server

        description : typing.Optional[str]
            Optional description of the FHIR provider

        client_id : typing.Optional[str]
            OAuth client ID (required for most auth methods)

        client_secret : typing.Optional[str]
            OAuth client secret (required for client_secret and on_behalf_of auth methods)

        service_account_key : typing.Optional[ServiceAccountKey]

        scopes : typing.Optional[str]
            OAuth scopes to request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            FHIR provider created successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.create(
            name="Epic Sandbox",
            provider="athenahealth",
            auth_method="client_secret",
            base_url="https://fhir.epic.com/interconnect-fhir-oauth/api/FHIR/R4",
        )
        """
        _response = self._raw_client.create(
            name=name,
            provider=provider,
            auth_method=auth_method,
            base_url=base_url,
            description=description,
            client_id=client_id,
            client_secret=client_secret,
            service_account_key=service_account_key,
            scopes=scopes,
            request_options=request_options,
        )
        return _response.data

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> FhirProviderListResponse:
        """
        Retrieves a list of all active FHIR providers for the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderListResponse
            FHIR providers retrieved successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def get(
        self, fhir_provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderResponse:
        """
        Retrieves a specific FHIR provider configuration by its ID

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            FHIR provider retrieved successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.get(
            fhir_provider_id="fhir_provider_id",
        )
        """
        _response = self._raw_client.get(fhir_provider_id, request_options=request_options)
        return _response.data

    def delete(
        self, fhir_provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderDeleteResponse:
        """
        Soft deletes a FHIR provider by setting is_active to false

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderDeleteResponse
            FHIR provider deleted successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.delete(
            fhir_provider_id="fhir_provider_id",
        )
        """
        _response = self._raw_client.delete(fhir_provider_id, request_options=request_options)
        return _response.data

    def add_auth_config(
        self,
        fhir_provider_id: str,
        *,
        auth_method: AuthMethod,
        client_secret: typing.Optional[str] = OMIT,
        service_account_key: typing.Optional[ServiceAccountKey] = OMIT,
        credential_expiry: typing.Optional[dt.datetime] = OMIT,
        scopes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirProviderResponse:
        """
        Adds a new authentication configuration to an existing FHIR provider. This enables key rotation and multiple auth configurations per provider.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to add auth config to

        auth_method : AuthMethod

        client_secret : typing.Optional[str]
            OAuth client secret (required for client_secret and on_behalf_of auth methods)

        service_account_key : typing.Optional[ServiceAccountKey]

        credential_expiry : typing.Optional[dt.datetime]
            Expiry time for JWT credentials (only applicable for JWT auth method)

        scopes : typing.Optional[str]
            OAuth scopes to request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            Auth configuration added successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.add_auth_config(
            fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
            auth_method="client_secret",
        )
        """
        _response = self._raw_client.add_auth_config(
            fhir_provider_id,
            auth_method=auth_method,
            client_secret=client_secret,
            service_account_key=service_account_key,
            credential_expiry=credential_expiry,
            scopes=scopes,
            request_options=request_options,
        )
        return _response.data

    def set_active_auth_config(
        self, fhir_provider_id: str, *, auth_config_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderSetActiveAuthConfigResponse:
        """
        Sets which authentication configuration should be active for a FHIR provider. Only one auth config can be active at a time.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider

        auth_config_id : str
            ID of the auth configuration to set as active

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderSetActiveAuthConfigResponse
            Active auth configuration set successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.set_active_auth_config(
            fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
            auth_config_id="auth-config-123",
        )
        """
        _response = self._raw_client.set_active_auth_config(
            fhir_provider_id, auth_config_id=auth_config_id, request_options=request_options
        )
        return _response.data

    def remove_auth_config(
        self, fhir_provider_id: str, *, auth_config_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderRemoveAuthConfigResponse:
        """
        Removes an authentication configuration from a FHIR provider. Cannot remove the currently active auth configuration.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider

        auth_config_id : str
            ID of the auth configuration to remove

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderRemoveAuthConfigResponse
            Auth configuration removed successfully

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.fhir_provider.remove_auth_config(
            fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
            auth_config_id="auth-config-123",
        )
        """
        _response = self._raw_client.remove_auth_config(
            fhir_provider_id, auth_config_id=auth_config_id, request_options=request_options
        )
        return _response.data


class AsyncFhirProviderClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFhirProviderClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFhirProviderClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFhirProviderClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        name: str,
        provider: Provider,
        auth_method: AuthMethod,
        base_url: str,
        description: typing.Optional[str] = OMIT,
        client_id: typing.Optional[str] = OMIT,
        client_secret: typing.Optional[str] = OMIT,
        service_account_key: typing.Optional[ServiceAccountKey] = OMIT,
        scopes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirProviderResponse:
        """
        Creates a new FHIR provider configuration with authentication credentials

        Parameters
        ----------
        name : str
            Display name for the FHIR provider

        provider : Provider

        auth_method : AuthMethod

        base_url : str
            Base URL of the FHIR server

        description : typing.Optional[str]
            Optional description of the FHIR provider

        client_id : typing.Optional[str]
            OAuth client ID (required for most auth methods)

        client_secret : typing.Optional[str]
            OAuth client secret (required for client_secret and on_behalf_of auth methods)

        service_account_key : typing.Optional[ServiceAccountKey]

        scopes : typing.Optional[str]
            OAuth scopes to request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            FHIR provider created successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.create(
                name="Epic Sandbox",
                provider="athenahealth",
                auth_method="client_secret",
                base_url="https://fhir.epic.com/interconnect-fhir-oauth/api/FHIR/R4",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            provider=provider,
            auth_method=auth_method,
            base_url=base_url,
            description=description,
            client_id=client_id,
            client_secret=client_secret,
            service_account_key=service_account_key,
            scopes=scopes,
            request_options=request_options,
        )
        return _response.data

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> FhirProviderListResponse:
        """
        Retrieves a list of all active FHIR providers for the authenticated user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderListResponse
            FHIR providers retrieved successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def get(
        self, fhir_provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderResponse:
        """
        Retrieves a specific FHIR provider configuration by its ID

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            FHIR provider retrieved successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.get(
                fhir_provider_id="fhir_provider_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(fhir_provider_id, request_options=request_options)
        return _response.data

    async def delete(
        self, fhir_provider_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderDeleteResponse:
        """
        Soft deletes a FHIR provider by setting is_active to false

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderDeleteResponse
            FHIR provider deleted successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.delete(
                fhir_provider_id="fhir_provider_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(fhir_provider_id, request_options=request_options)
        return _response.data

    async def add_auth_config(
        self,
        fhir_provider_id: str,
        *,
        auth_method: AuthMethod,
        client_secret: typing.Optional[str] = OMIT,
        service_account_key: typing.Optional[ServiceAccountKey] = OMIT,
        credential_expiry: typing.Optional[dt.datetime] = OMIT,
        scopes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirProviderResponse:
        """
        Adds a new authentication configuration to an existing FHIR provider. This enables key rotation and multiple auth configurations per provider.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider to add auth config to

        auth_method : AuthMethod

        client_secret : typing.Optional[str]
            OAuth client secret (required for client_secret and on_behalf_of auth methods)

        service_account_key : typing.Optional[ServiceAccountKey]

        credential_expiry : typing.Optional[dt.datetime]
            Expiry time for JWT credentials (only applicable for JWT auth method)

        scopes : typing.Optional[str]
            OAuth scopes to request

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderResponse
            Auth configuration added successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.add_auth_config(
                fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
                auth_method="client_secret",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_auth_config(
            fhir_provider_id,
            auth_method=auth_method,
            client_secret=client_secret,
            service_account_key=service_account_key,
            credential_expiry=credential_expiry,
            scopes=scopes,
            request_options=request_options,
        )
        return _response.data

    async def set_active_auth_config(
        self, fhir_provider_id: str, *, auth_config_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderSetActiveAuthConfigResponse:
        """
        Sets which authentication configuration should be active for a FHIR provider. Only one auth config can be active at a time.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider

        auth_config_id : str
            ID of the auth configuration to set as active

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderSetActiveAuthConfigResponse
            Active auth configuration set successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.set_active_auth_config(
                fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
                auth_config_id="auth-config-123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.set_active_auth_config(
            fhir_provider_id, auth_config_id=auth_config_id, request_options=request_options
        )
        return _response.data

    async def remove_auth_config(
        self, fhir_provider_id: str, *, auth_config_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> FhirProviderRemoveAuthConfigResponse:
        """
        Removes an authentication configuration from a FHIR provider. Cannot remove the currently active auth configuration.

        Parameters
        ----------
        fhir_provider_id : str
            ID of the FHIR provider

        auth_config_id : str
            ID of the auth configuration to remove

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirProviderRemoveAuthConfigResponse
            Auth configuration removed successfully

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.fhir_provider.remove_auth_config(
                fhir_provider_id="1716d214-de93-43a4-aa6b-a878d864e2ad",
                auth_config_id="auth-config-123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remove_auth_config(
            fhir_provider_id, auth_config_id=auth_config_id, request_options=request_options
        )
        return _response.data
