# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .auth_method import AuthMethod
from .json_web_key import JsonWebKey
from .smart_configuration import SmartConfiguration


class FhirProviderAuthConfig(UniversalBaseModel):
    """
    Authentication configuration for a FHIR provider (sensitive fields are hidden from JSON responses)
    """

    auth_config_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for this auth configuration
    """

    auth_method: typing.Optional[AuthMethod] = None
    is_active_auth_config: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this auth configuration is currently active
    """

    public_key_cert_pem: typing.Optional[str] = pydantic.Field(default=None)
    """
    Public key certificate in PEM format (visible for JWT auth)
    """

    json_web_key: typing.Optional[JsonWebKey] = None
    credential_expiry: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Expiry time for credentials (JWT auth only)
    """

    smart_configuration: typing.Optional[SmartConfiguration] = None
    scopes: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth scopes
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
