# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .fhir_provider_auth_config import FhirProviderAuthConfig
from .provider import Provider


class FhirProviderTemplate(UniversalBaseModel):
    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier for the FHIR provider
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user who owns this FHIR provider
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name for the FHIR provider
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional description of the FHIR provider
    """

    provider: typing.Optional[Provider] = None
    base_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL of the FHIR server
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth client ID
    """

    auth_configs: typing.Optional[typing.Dict[str, FhirProviderAuthConfig]] = pydantic.Field(default=None)
    """
    Map of authentication configurations (key is auth_config_id)
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the FHIR provider is active
    """

    last_updated: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    Timestamp when the provider was last updated
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
