# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class JsonWebKey(UniversalBaseModel):
    """
    JSON Web Key structure for RSA keys used in JWT authentication. Keys are automatically generated using RSA-2048 with RS384 signing algorithm. The Key ID (kid) is derived from a SHA256 hash of the public key PEM format.
    """

    kty: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key Type
    """

    use: typing.Optional[str] = pydantic.Field(default=None)
    """
    Usage (sig for signature)
    """

    kid: typing.Optional[str] = pydantic.Field(default=None)
    """
    Key ID - SHA256 hash of the public key PEM (including headers) encoded as base64url. Generated by taking the public key in PEM format, hashing with SHA256, then base64url encoding (replacing + with -, / with _, and removing padding).
    """

    alg: typing.Optional[str] = pydantic.Field(default=None)
    """
    Algorithm used for JWT signing (RSA with SHA-384)
    """

    n: typing.Optional[str] = pydantic.Field(default=None)
    """
    RSA Modulus (base64url encoded)
    """

    e: typing.Optional[str] = pydantic.Field(default=None)
    """
    RSA Exponent (base64url encoded)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
