# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata


class ServiceAccountKey(UniversalBaseModel):
    """
    Google Cloud Service Account key (required for google_healthcare auth method)
    """

    type: str
    project_id: str
    private_key_id: str
    private_key: str
    client_email: str
    client_id: str
    auth_uri: str
    token_uri: str
    auth_provider_x509cert_url: typing_extensions.Annotated[str, FieldMetadata(alias="auth_provider_x509_cert_url")]
    client_x509cert_url: typing_extensions.Annotated[str, FieldMetadata(alias="client_x509_cert_url")]
    universe_domain: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
