# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SmartConfiguration(UniversalBaseModel):
    """
    SMART on FHIR configuration for OAuth-based providers
    """

    authorization_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth2 authorization endpoint
    """

    token_endpoint: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth2 token endpoint
    """

    issuer: typing.Optional[str] = pydantic.Field(default=None)
    """
    OIDC issuer URL
    """

    jwks_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    JSON Web Key Set URI
    """

    scopes_supported: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of supported scopes
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
