# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawLang2FhirClient, RawLang2FhirClient
from .types.create_request_resource import CreateRequestResource
from .types.document_request_file_type import DocumentRequestFileType
from .types.document_request_resource import DocumentRequestResource
from .types.fhir_resource import FhirResource
from .types.lang2fhir_upload_profile_response import Lang2FhirUploadProfileResponse
from .types.search_response import SearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class Lang2FhirClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawLang2FhirClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawLang2FhirClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawLang2FhirClient
        """
        return self._raw_client

    def create(
        self,
        *,
        version: str,
        resource: CreateRequestResource,
        text: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Converts natural language text into a structured FHIR resource

        Parameters
        ----------
        version : str
            FHIR version to use

        resource : CreateRequestResource
            Type of FHIR resource to create. Use 'auto' for automatic resource type detection, or specify a supported US Core profile. Recommended to use the supported US Core Profiles for validated results but you can also use any custom profile you've uploaded (if you're a develop or launch customer)

        text : str
            Natural language text to convert

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Successfully created FHIR resource

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.lang2fhir.create(
            version="R4",
            resource="auto",
            text="Patient has severe asthma with acute exacerbation",
        )
        """
        _response = self._raw_client.create(
            version=version, resource=resource, text=text, request_options=request_options
        )
        return _response.data

    def search(self, *, text: str, request_options: typing.Optional[RequestOptions] = None) -> SearchResponse:
        """
        Converts natural language text into FHIR search parameters

        Parameters
        ----------
        text : str
            Natural language text to convert into FHIR search parameters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successfully generated FHIR search parameters

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.lang2fhir.search(
            text="Appointments between March 2-9, 2025",
        )
        """
        _response = self._raw_client.search(text=text, request_options=request_options)
        return _response.data

    def upload_profile(
        self, *, version: str, resource: str, profile: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Lang2FhirUploadProfileResponse:
        """
        Upload a custom FHIR StructureDefinition profile for use with the lang2fhir service

        Parameters
        ----------
        version : str
            FHIR version that this profile implements

        resource : str
            Name for the custom resource profile (will be converted to lowercase)

        profile : str
            Base64 encoded JSON string of the FHIR StructureDefinition profile

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirUploadProfileResponse
            Profile successfully uploaded

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.lang2fhir.upload_profile(
            version="version",
            resource="custom-patient",
            profile="profile",
        )
        """
        _response = self._raw_client.upload_profile(
            version=version, resource=resource, profile=profile, request_options=request_options
        )
        return _response.data

    def document(
        self,
        *,
        version: str,
        resource: DocumentRequestResource,
        content: str,
        file_type: DocumentRequestFileType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Extracts text from a document (PDF or image) and converts it into a structured FHIR resource

        Parameters
        ----------
        version : str
            FHIR version to use

        resource : DocumentRequestResource
            Type of FHIR resource to create (questionnaire and US Core questionnaireresponse profiles currently supported)

        content : str
            Base64 encoded file content

        file_type : DocumentRequestFileType
            MIME type of the file

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Successfully created FHIR resource from document

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.lang2fhir.document(
            version="R4",
            resource="questionnaire",
            content="content",
            file_type="application/pdf",
        )
        """
        _response = self._raw_client.document(
            version=version, resource=resource, content=content, file_type=file_type, request_options=request_options
        )
        return _response.data


class AsyncLang2FhirClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawLang2FhirClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawLang2FhirClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawLang2FhirClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        version: str,
        resource: CreateRequestResource,
        text: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Converts natural language text into a structured FHIR resource

        Parameters
        ----------
        version : str
            FHIR version to use

        resource : CreateRequestResource
            Type of FHIR resource to create. Use 'auto' for automatic resource type detection, or specify a supported US Core profile. Recommended to use the supported US Core Profiles for validated results but you can also use any custom profile you've uploaded (if you're a develop or launch customer)

        text : str
            Natural language text to convert

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Successfully created FHIR resource

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.lang2fhir.create(
                version="R4",
                resource="auto",
                text="Patient has severe asthma with acute exacerbation",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            version=version, resource=resource, text=text, request_options=request_options
        )
        return _response.data

    async def search(self, *, text: str, request_options: typing.Optional[RequestOptions] = None) -> SearchResponse:
        """
        Converts natural language text into FHIR search parameters

        Parameters
        ----------
        text : str
            Natural language text to convert into FHIR search parameters

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SearchResponse
            Successfully generated FHIR search parameters

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.lang2fhir.search(
                text="Appointments between March 2-9, 2025",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(text=text, request_options=request_options)
        return _response.data

    async def upload_profile(
        self, *, version: str, resource: str, profile: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Lang2FhirUploadProfileResponse:
        """
        Upload a custom FHIR StructureDefinition profile for use with the lang2fhir service

        Parameters
        ----------
        version : str
            FHIR version that this profile implements

        resource : str
            Name for the custom resource profile (will be converted to lowercase)

        profile : str
            Base64 encoded JSON string of the FHIR StructureDefinition profile

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirUploadProfileResponse
            Profile successfully uploaded

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.lang2fhir.upload_profile(
                version="version",
                resource="custom-patient",
                profile="profile",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.upload_profile(
            version=version, resource=resource, profile=profile, request_options=request_options
        )
        return _response.data

    async def document(
        self,
        *,
        version: str,
        resource: DocumentRequestResource,
        content: str,
        file_type: DocumentRequestFileType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> FhirResource:
        """
        Extracts text from a document (PDF or image) and converts it into a structured FHIR resource

        Parameters
        ----------
        version : str
            FHIR version to use

        resource : DocumentRequestResource
            Type of FHIR resource to create (questionnaire and US Core questionnaireresponse profiles currently supported)

        content : str
            Base64 encoded file content

        file_type : DocumentRequestFileType
            MIME type of the file

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        FhirResource
            Successfully created FHIR resource from document

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.lang2fhir.document(
                version="R4",
                resource="questionnaire",
                content="content",
                file_type="application/pdf",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.document(
            version=version, resource=resource, content=content, file_type=file_type, request_options=request_options
        )
        return _response.data
