# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .mcp_server.client import AsyncMcpServerClient, McpServerClient
from .raw_client import AsyncRawToolsClient, RawToolsClient
from .types.cohort_response import CohortResponse
from .types.lang2fhir_and_create_request_resource import Lang2FhirAndCreateRequestResource
from .types.lang2fhir_and_create_response import Lang2FhirAndCreateResponse
from .types.lang2fhir_and_search_response import Lang2FhirAndSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawToolsClient(client_wrapper=client_wrapper)
        self.mcp_server = McpServerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawToolsClient
        """
        return self._raw_client

    def create_fhir_resource(
        self,
        *,
        resource: Lang2FhirAndCreateRequestResource,
        text: str,
        provider: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Lang2FhirAndCreateResponse:
        """
        Converts natural language to FHIR resource and optionally stores it in a FHIR server

        Parameters
        ----------
        resource : Lang2FhirAndCreateRequestResource
            Type of FHIR resource to create. Use 'auto' for automatic resource type detection, or specify a supported US Core profile.

        text : str
            Natural language text to convert to FHIR resource

        provider : typing.Optional[str]
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirAndCreateResponse
            Successfully created FHIR resource

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.create_fhir_resource(
            resource="auto",
            text="Patient John Doe has severe asthma with acute exacerbation",
        )
        """
        _response = self._raw_client.create_fhir_resource(
            resource=resource, text=text, provider=provider, request_options=request_options
        )
        return _response.data

    def search_fhir_resources(
        self,
        *,
        text: str,
        patient_id: typing.Optional[str] = OMIT,
        practitioner_id: typing.Optional[str] = OMIT,
        count: typing.Optional[int] = OMIT,
        provider: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Lang2FhirAndSearchResponse:
        """
        Converts natural language to FHIR search parameters and executes search in FHIR server

        Parameters
        ----------
        text : str
            Natural language text to convert to FHIR search parameters

        patient_id : typing.Optional[str]
            Patient ID to filter results

        practitioner_id : typing.Optional[str]
            Practitioner ID to filter results

        count : typing.Optional[int]
            Maximum number of results to return

        provider : typing.Optional[str]
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirAndSearchResponse
            Successfully generated search and retrieved results

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.search_fhir_resources(
            text="Find all appointments for patient John Doe next week",
        )
        """
        _response = self._raw_client.search_fhir_resources(
            text=text,
            patient_id=patient_id,
            practitioner_id=practitioner_id,
            count=count,
            provider=provider,
            request_options=request_options,
        )
        return _response.data

    def analyze_cohort(
        self, *, text: str, provider: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CohortResponse:
        """
        Uses LLM to extract search concepts from natural language and builds patient cohorts with inclusion/exclusion criteria

        Parameters
        ----------
        text : str
            Natural language text describing the patient cohort criteria

        provider : str
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CohortResponse
            Successfully analyzed cohort and retrieved patient list

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.analyze_cohort(
            text="female patients over 20 with diabetes but not hypertension",
            provider="550e8400-e29b-41d4-a716-446655440000",
        )
        """
        _response = self._raw_client.analyze_cohort(text=text, provider=provider, request_options=request_options)
        return _response.data


class AsyncToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawToolsClient(client_wrapper=client_wrapper)
        self.mcp_server = AsyncMcpServerClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawToolsClient
        """
        return self._raw_client

    async def create_fhir_resource(
        self,
        *,
        resource: Lang2FhirAndCreateRequestResource,
        text: str,
        provider: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Lang2FhirAndCreateResponse:
        """
        Converts natural language to FHIR resource and optionally stores it in a FHIR server

        Parameters
        ----------
        resource : Lang2FhirAndCreateRequestResource
            Type of FHIR resource to create. Use 'auto' for automatic resource type detection, or specify a supported US Core profile.

        text : str
            Natural language text to convert to FHIR resource

        provider : typing.Optional[str]
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirAndCreateResponse
            Successfully created FHIR resource

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.create_fhir_resource(
                resource="auto",
                text="Patient John Doe has severe asthma with acute exacerbation",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_fhir_resource(
            resource=resource, text=text, provider=provider, request_options=request_options
        )
        return _response.data

    async def search_fhir_resources(
        self,
        *,
        text: str,
        patient_id: typing.Optional[str] = OMIT,
        practitioner_id: typing.Optional[str] = OMIT,
        count: typing.Optional[int] = OMIT,
        provider: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Lang2FhirAndSearchResponse:
        """
        Converts natural language to FHIR search parameters and executes search in FHIR server

        Parameters
        ----------
        text : str
            Natural language text to convert to FHIR search parameters

        patient_id : typing.Optional[str]
            Patient ID to filter results

        practitioner_id : typing.Optional[str]
            Practitioner ID to filter results

        count : typing.Optional[int]
            Maximum number of results to return

        provider : typing.Optional[str]
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Lang2FhirAndSearchResponse
            Successfully generated search and retrieved results

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.search_fhir_resources(
                text="Find all appointments for patient John Doe next week",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_fhir_resources(
            text=text,
            patient_id=patient_id,
            practitioner_id=practitioner_id,
            count=count,
            provider=provider,
            request_options=request_options,
        )
        return _response.data

    async def analyze_cohort(
        self, *, text: str, provider: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CohortResponse:
        """
        Uses LLM to extract search concepts from natural language and builds patient cohorts with inclusion/exclusion criteria

        Parameters
        ----------
        text : str
            Natural language text describing the patient cohort criteria

        provider : str
            FHIR provider ID - must be a valid UUID from existing FHIR providers. also supports provider by name (e.g. medplum)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CohortResponse
            Successfully analyzed cohort and retrieved patient list

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.analyze_cohort(
                text="female patients over 20 with diabetes but not hypertension",
                provider="550e8400-e29b-41d4-a716-446655440000",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.analyze_cohort(text=text, provider=provider, request_options=request_options)
        return _response.data
