# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.mcp_server_response import McpServerResponse
from .raw_client import AsyncRawMcpServerClient, RawMcpServerClient
from .tools.client import AsyncToolsClient, ToolsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class McpServerClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMcpServerClient(client_wrapper=client_wrapper)
        self.tools = ToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMcpServerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMcpServerClient
        """
        return self._raw_client

    def create(
        self, *, name: str, mcp_server_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponse:
        """
        Creates a new MCP server

        Parameters
        ----------
        name : str
            Name of the MCP server

        mcp_server_url : str
            URL of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully created MCP server

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.create(
            name="My MCP Server",
            mcp_server_url="https://mcp.example.com",
        )
        """
        _response = self._raw_client.create(name=name, mcp_server_url=mcp_server_url, request_options=request_options)
        return _response.data

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> McpServerResponse:
        """
        Lists all MCP servers for a specific user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully listed MCP servers

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def get(self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> McpServerResponse:
        """
        Gets a MCP server by ID

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully retrieved MCP server

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.get(
            mcp_server_id="mcp_server_id",
        )
        """
        _response = self._raw_client.get(mcp_server_id, request_options=request_options)
        return _response.data

    def delete(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponse:
        """
        Deletes a MCP server by ID

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully deleted MCP server

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.delete(
            mcp_server_id="mcp_server_id",
        )
        """
        _response = self._raw_client.delete(mcp_server_id, request_options=request_options)
        return _response.data


class AsyncMcpServerClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMcpServerClient(client_wrapper=client_wrapper)
        self.tools = AsyncToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMcpServerClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMcpServerClient
        """
        return self._raw_client

    async def create(
        self, *, name: str, mcp_server_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponse:
        """
        Creates a new MCP server

        Parameters
        ----------
        name : str
            Name of the MCP server

        mcp_server_url : str
            URL of the MCP server

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully created MCP server

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.create(
                name="My MCP Server",
                mcp_server_url="https://mcp.example.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, mcp_server_url=mcp_server_url, request_options=request_options
        )
        return _response.data

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> McpServerResponse:
        """
        Lists all MCP servers for a specific user

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully listed MCP servers

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def get(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponse:
        """
        Gets a MCP server by ID

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully retrieved MCP server

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.get(
                mcp_server_id="mcp_server_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(mcp_server_id, request_options=request_options)
        return _response.data

    async def delete(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerResponse:
        """
        Deletes a MCP server by ID

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerResponse
            Successfully deleted MCP server

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.delete(
                mcp_server_id="mcp_server_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(mcp_server_id, request_options=request_options)
        return _response.data
