# This file was auto-generated by Fern from our API Definition.

import typing

from ....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ....core.request_options import RequestOptions
from ...types.mcp_server_tool_call_response import McpServerToolCallResponse
from ...types.mcp_server_tool_response import McpServerToolResponse
from .raw_client import AsyncRawToolsClient, RawToolsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ToolsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawToolsClient
        """
        return self._raw_client

    def list(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Lists all MCP server tools for a specific MCP server

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to list tools for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully listed MCP server tools

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.tools.list(
            mcp_server_id="mcp_server_id",
        )
        """
        _response = self._raw_client.list(mcp_server_id, request_options=request_options)
        return _response.data

    def get(
        self, mcp_server_tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Gets a MCP server tool by ID

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully retrieved MCP server tool

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.tools.get(
            mcp_server_tool_id="mcp_server_tool_id",
        )
        """
        _response = self._raw_client.get(mcp_server_tool_id, request_options=request_options)
        return _response.data

    def delete(
        self, mcp_server_tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Deletes a MCP server tool by ID

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully deleted MCP server tool

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.tools.delete(
            mcp_server_tool_id="mcp_server_tool_id",
        )
        """
        _response = self._raw_client.delete(mcp_server_tool_id, request_options=request_options)
        return _response.data

    def call(
        self,
        mcp_server_tool_id: str,
        *,
        arguments: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> McpServerToolCallResponse:
        """
        Calls a MCP server tool

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to call

        arguments : typing.Dict[str, typing.Optional[typing.Any]]
            Arguments to pass to the MCP server tool

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolCallResponse
            Successfully called MCP server tool

        Examples
        --------
        from phenoml import phenoml

        client = phenoml(
            token="YOUR_TOKEN",
        )
        client.tools.mcp_server.tools.call(
            mcp_server_tool_id="mcp_server_tool_id",
            arguments={"title": "PhenoML Agent API"},
        )
        """
        _response = self._raw_client.call(mcp_server_tool_id, arguments=arguments, request_options=request_options)
        return _response.data


class AsyncToolsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawToolsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawToolsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawToolsClient
        """
        return self._raw_client

    async def list(
        self, mcp_server_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Lists all MCP server tools for a specific MCP server

        Parameters
        ----------
        mcp_server_id : str
            ID of the MCP server to list tools for

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully listed MCP server tools

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.tools.list(
                mcp_server_id="mcp_server_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(mcp_server_id, request_options=request_options)
        return _response.data

    async def get(
        self, mcp_server_tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Gets a MCP server tool by ID

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully retrieved MCP server tool

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.tools.get(
                mcp_server_tool_id="mcp_server_tool_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(mcp_server_tool_id, request_options=request_options)
        return _response.data

    async def delete(
        self, mcp_server_tool_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> McpServerToolResponse:
        """
        Deletes a MCP server tool by ID

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to delete

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolResponse
            Successfully deleted MCP server tool

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.tools.delete(
                mcp_server_tool_id="mcp_server_tool_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(mcp_server_tool_id, request_options=request_options)
        return _response.data

    async def call(
        self,
        mcp_server_tool_id: str,
        *,
        arguments: typing.Dict[str, typing.Optional[typing.Any]],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> McpServerToolCallResponse:
        """
        Calls a MCP server tool

        Parameters
        ----------
        mcp_server_tool_id : str
            ID of the MCP server tool to call

        arguments : typing.Dict[str, typing.Optional[typing.Any]]
            Arguments to pass to the MCP server tool

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        McpServerToolCallResponse
            Successfully called MCP server tool

        Examples
        --------
        import asyncio

        from phenoml import Asyncphenoml

        client = Asyncphenoml(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tools.mcp_server.tools.call(
                mcp_server_tool_id="mcp_server_tool_id",
                arguments={"title": "PhenoML Agent API"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.call(
            mcp_server_tool_id, arguments=arguments, request_options=request_options
        )
        return _response.data
