# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .search_concept import SearchConcept


class CohortResponse(UniversalBaseModel):
    success: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the cohort analysis was successful
    """

    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Status message with details about the analysis
    """

    patient_ids: typing_extensions.Annotated[typing.Optional[typing.List[str]], FieldMetadata(alias="patientIds")] = (
        pydantic.Field(default=None)
    )
    """
    Array of patient IDs that match the cohort criteria
    """

    patient_count: typing_extensions.Annotated[typing.Optional[int], FieldMetadata(alias="patientCount")] = (
        pydantic.Field(default=None)
    )
    """
    Total number of patients in the cohort
    """

    queries: typing.Optional[typing.List[SearchConcept]] = pydantic.Field(default=None)
    """
    Individual search concepts that were identified and executed
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
