# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class Lang2FhirAndSearchResponse(UniversalBaseModel):
    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The FHIR resource type identified for the search
    """

    search_params: typing.Optional[str] = pydantic.Field(default=None)
    """
    FHIR search parameters in standard format
    """

    fhir_results: typing.Optional[typing.List[typing.Dict[str, typing.Optional[typing.Any]]]] = pydantic.Field(
        default=None
    )
    """
    Array of FHIR resources returned from the search
    """

    success: typing.Optional[bool] = None
    message: typing.Optional[str] = pydantic.Field(default=None)
    """
    Status message
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
