# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class McpServerToolResponseData(UniversalBaseModel):
    """
    MCP server tool data
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the MCP server tool
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user who created the MCP server tool
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the MCP server tool
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the MCP server tool
    """

    input_schema: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Input schema of the MCP server tool
    """

    mcp_server_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the MCP server that the tool belongs to
    """

    mcp_server_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    URL of the MCP server
    """

    is_active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the MCP server tool is active
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
