# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SearchConcept(UniversalBaseModel):
    """
    A single search concept detected in cohort mode
    """

    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The FHIR resource type identified for this concept
    """

    search_params: typing.Optional[str] = pydantic.Field(default=None)
    """
    FHIR search parameters for this concept
    """

    concept: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of what this search represents
    """

    exclude: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this is an exclusion criteria
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
