# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import httpx

from .ssh import (
    SSHResource,
    AsyncSSHResource,
    SSHResourceWithRawResponse,
    AsyncSSHResourceWithRawResponse,
    SSHResourceWithStreamingResponse,
    AsyncSSHResourceWithStreamingResponse,
)
from ...types import auth_session_login_params
from ..._types import NOT_GIVEN, Body, Query, Headers, NoneType, NotGiven
from ..._utils import maybe_transform, async_maybe_transform
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ..._base_client import make_request_options
from ...types.auth_session_login_response import AuthSessionLoginResponse

__all__ = ["AuthResource", "AsyncAuthResource"]


class AuthResource(SyncAPIResource):
    @cached_property
    def ssh(self) -> SSHResource:
        return SSHResource(self._client)

    @cached_property
    def with_raw_response(self) -> AuthResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Fluidize-Inc/fluidize-python-sdk#accessing-raw-response-data-eg-headers
        """
        return AuthResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AuthResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Fluidize-Inc/fluidize-python-sdk#with_streaming_response
        """
        return AuthResourceWithStreamingResponse(self)

    def logout(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """Clears the session cookie upon user logout."""
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return self._post(
            "/auth/logout",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )

    def session_login(
        self,
        *,
        id_token: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AuthSessionLoginResponse:
        """
        Handles user session login.

        This endpoint receives an ID token from the client, verifies it, and then either
        retrieves the existing user or creates a new one in the backend database. It
        also sets a secure, HttpOnly session cookie.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._post(
            "/auth/session-login",
            body=maybe_transform({"id_token": id_token}, auth_session_login_params.AuthSessionLoginParams),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AuthSessionLoginResponse,
        )


class AsyncAuthResource(AsyncAPIResource):
    @cached_property
    def ssh(self) -> AsyncSSHResource:
        return AsyncSSHResource(self._client)

    @cached_property
    def with_raw_response(self) -> AsyncAuthResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Fluidize-Inc/fluidize-python-sdk#accessing-raw-response-data-eg-headers
        """
        return AsyncAuthResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncAuthResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Fluidize-Inc/fluidize-python-sdk#with_streaming_response
        """
        return AsyncAuthResourceWithStreamingResponse(self)

    async def logout(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> None:
        """Clears the session cookie upon user logout."""
        extra_headers = {"Accept": "*/*", **(extra_headers or {})}
        return await self._post(
            "/auth/logout",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NoneType,
        )

    async def session_login(
        self,
        *,
        id_token: str,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AuthSessionLoginResponse:
        """
        Handles user session login.

        This endpoint receives an ID token from the client, verifies it, and then either
        retrieves the existing user or creates a new one in the backend database. It
        also sets a secure, HttpOnly session cookie.

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return await self._post(
            "/auth/session-login",
            body=await async_maybe_transform({"id_token": id_token}, auth_session_login_params.AuthSessionLoginParams),
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=AuthSessionLoginResponse,
        )


class AuthResourceWithRawResponse:
    def __init__(self, auth: AuthResource) -> None:
        self._auth = auth

        self.logout = to_raw_response_wrapper(
            auth.logout,
        )
        self.session_login = to_raw_response_wrapper(
            auth.session_login,
        )

    @cached_property
    def ssh(self) -> SSHResourceWithRawResponse:
        return SSHResourceWithRawResponse(self._auth.ssh)


class AsyncAuthResourceWithRawResponse:
    def __init__(self, auth: AsyncAuthResource) -> None:
        self._auth = auth

        self.logout = async_to_raw_response_wrapper(
            auth.logout,
        )
        self.session_login = async_to_raw_response_wrapper(
            auth.session_login,
        )

    @cached_property
    def ssh(self) -> AsyncSSHResourceWithRawResponse:
        return AsyncSSHResourceWithRawResponse(self._auth.ssh)


class AuthResourceWithStreamingResponse:
    def __init__(self, auth: AuthResource) -> None:
        self._auth = auth

        self.logout = to_streamed_response_wrapper(
            auth.logout,
        )
        self.session_login = to_streamed_response_wrapper(
            auth.session_login,
        )

    @cached_property
    def ssh(self) -> SSHResourceWithStreamingResponse:
        return SSHResourceWithStreamingResponse(self._auth.ssh)


class AsyncAuthResourceWithStreamingResponse:
    def __init__(self, auth: AsyncAuthResource) -> None:
        self._auth = auth

        self.logout = async_to_streamed_response_wrapper(
            auth.logout,
        )
        self.session_login = async_to_streamed_response_wrapper(
            auth.session_login,
        )

    @cached_property
    def ssh(self) -> AsyncSSHResourceWithStreamingResponse:
        return AsyncSSHResourceWithStreamingResponse(self._auth.ssh)
