# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from fluidize_sdk import FluidizeSDK, AsyncFluidizeSDK

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestLogs:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip()
    @parametrize
    def test_method_stream(self, client: FluidizeSDK) -> None:
        log = client.runs.logs.stream(
            run_id="run_id",
        )
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_method_stream_with_all_params(self, client: FluidizeSDK) -> None:
        log = client.runs.logs.stream(
            run_id="run_id",
            token="token",
        )
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_raw_response_stream(self, client: FluidizeSDK) -> None:
        response = client.runs.logs.with_raw_response.stream(
            run_id="run_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        log = response.parse()
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_streaming_response_stream(self, client: FluidizeSDK) -> None:
        with client.runs.logs.with_streaming_response.stream(
            run_id="run_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            log = response.parse()
            assert_matches_type(object, log, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    def test_path_params_stream(self, client: FluidizeSDK) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `run_id` but received ''"):
            client.runs.logs.with_raw_response.stream(
                run_id="",
            )


class TestAsyncLogs:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip()
    @parametrize
    async def test_method_stream(self, async_client: AsyncFluidizeSDK) -> None:
        log = await async_client.runs.logs.stream(
            run_id="run_id",
        )
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_method_stream_with_all_params(self, async_client: AsyncFluidizeSDK) -> None:
        log = await async_client.runs.logs.stream(
            run_id="run_id",
            token="token",
        )
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_raw_response_stream(self, async_client: AsyncFluidizeSDK) -> None:
        response = await async_client.runs.logs.with_raw_response.stream(
            run_id="run_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        log = await response.parse()
        assert_matches_type(object, log, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_streaming_response_stream(self, async_client: AsyncFluidizeSDK) -> None:
        async with async_client.runs.logs.with_streaming_response.stream(
            run_id="run_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            log = await response.parse()
            assert_matches_type(object, log, path=["response"])

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    async def test_path_params_stream(self, async_client: AsyncFluidizeSDK) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `run_id` but received ''"):
            await async_client.runs.logs.with_raw_response.stream(
                run_id="",
            )
