# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from fluidize_sdk import FluidizeSDK, AsyncFluidizeSDK
from fluidize_sdk.types import AuthSessionLoginResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestAuth:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip()
    @parametrize
    def test_method_logout(self, client: FluidizeSDK) -> None:
        auth = client.auth.logout()
        assert auth is None

    @pytest.mark.skip()
    @parametrize
    def test_raw_response_logout(self, client: FluidizeSDK) -> None:
        response = client.auth.with_raw_response.logout()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        auth = response.parse()
        assert auth is None

    @pytest.mark.skip()
    @parametrize
    def test_streaming_response_logout(self, client: FluidizeSDK) -> None:
        with client.auth.with_streaming_response.logout() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            auth = response.parse()
            assert auth is None

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    def test_method_session_login(self, client: FluidizeSDK) -> None:
        auth = client.auth.session_login(
            id_token="id_token",
        )
        assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_raw_response_session_login(self, client: FluidizeSDK) -> None:
        response = client.auth.with_raw_response.session_login(
            id_token="id_token",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        auth = response.parse()
        assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_streaming_response_session_login(self, client: FluidizeSDK) -> None:
        with client.auth.with_streaming_response.session_login(
            id_token="id_token",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            auth = response.parse()
            assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncAuth:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip()
    @parametrize
    async def test_method_logout(self, async_client: AsyncFluidizeSDK) -> None:
        auth = await async_client.auth.logout()
        assert auth is None

    @pytest.mark.skip()
    @parametrize
    async def test_raw_response_logout(self, async_client: AsyncFluidizeSDK) -> None:
        response = await async_client.auth.with_raw_response.logout()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        auth = await response.parse()
        assert auth is None

    @pytest.mark.skip()
    @parametrize
    async def test_streaming_response_logout(self, async_client: AsyncFluidizeSDK) -> None:
        async with async_client.auth.with_streaming_response.logout() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            auth = await response.parse()
            assert auth is None

        assert cast(Any, response.is_closed) is True

    @pytest.mark.skip()
    @parametrize
    async def test_method_session_login(self, async_client: AsyncFluidizeSDK) -> None:
        auth = await async_client.auth.session_login(
            id_token="id_token",
        )
        assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_raw_response_session_login(self, async_client: AsyncFluidizeSDK) -> None:
        response = await async_client.auth.with_raw_response.session_login(
            id_token="id_token",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        auth = await response.parse()
        assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_streaming_response_session_login(self, async_client: AsyncFluidizeSDK) -> None:
        async with async_client.auth.with_streaming_response.session_login(
            id_token="id_token",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            auth = await response.parse()
            assert_matches_type(AuthSessionLoginResponse, auth, path=["response"])

        assert cast(Any, response.is_closed) is True
