# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from fluidize_sdk import FluidizeSDK, AsyncFluidizeSDK
from fluidize_sdk.types import TestConnectionCheckResponse

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestTestConnection:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @pytest.mark.skip()
    @parametrize
    def test_method_check(self, client: FluidizeSDK) -> None:
        test_connection = client.test_connection.check()
        assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_raw_response_check(self, client: FluidizeSDK) -> None:
        response = client.test_connection.with_raw_response.check()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        test_connection = response.parse()
        assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

    @pytest.mark.skip()
    @parametrize
    def test_streaming_response_check(self, client: FluidizeSDK) -> None:
        with client.test_connection.with_streaming_response.check() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            test_connection = response.parse()
            assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncTestConnection:
    parametrize = pytest.mark.parametrize(
        "async_client", [False, True, {"http_client": "aiohttp"}], indirect=True, ids=["loose", "strict", "aiohttp"]
    )

    @pytest.mark.skip()
    @parametrize
    async def test_method_check(self, async_client: AsyncFluidizeSDK) -> None:
        test_connection = await async_client.test_connection.check()
        assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_raw_response_check(self, async_client: AsyncFluidizeSDK) -> None:
        response = await async_client.test_connection.with_raw_response.check()

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        test_connection = await response.parse()
        assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

    @pytest.mark.skip()
    @parametrize
    async def test_streaming_response_check(self, async_client: AsyncFluidizeSDK) -> None:
        async with async_client.test_connection.with_streaming_response.check() as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            test_connection = await response.parse()
            assert_matches_type(TestConnectionCheckResponse, test_connection, path=["response"])

        assert cast(Any, response.is_closed) is True
