"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Capabilities that affect whether CloudFormation is allowed to change IAM resources
 */
var CloudFormationCapabilities;
(function (CloudFormationCapabilities) {
    /**
     * No IAM Capabilities
     *
     * Pass this capability if you wish to block the creation IAM resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["None"] = "";
    /**
     * Capability to create anonymous IAM resources
     *
     * Pass this capability if you're only creating anonymous resources.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["AnonymousIAM"] = "CAPABILITY_IAM";
    /**
     * Capability to create named IAM resources.
     *
     * Pass this capability if you're creating IAM resources that have physical
     * names.
     *
     * `CloudFormationCapabilities.NamedIAM` implies `CloudFormationCapabilities.IAM`; you don't have to pass both.
     * @link https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     */
    CloudFormationCapabilities["NamedIAM"] = "CAPABILITY_NAMED_IAM";
})(CloudFormationCapabilities = exports.CloudFormationCapabilities || (exports.CloudFormationCapabilities = {}));
//# sourceMappingURL=data:application/json;base64,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