import lambda = require('@aws-cdk/aws-lambda');
import sns = require('@aws-cdk/aws-sns');
import { Construct, Resource } from '@aws-cdk/cdk';
/**
 * Collection of arbitrary properties
 */
export declare type Properties = {
    [key: string]: any;
};
export declare class CustomResourceProvider {
    readonly serviceToken: string;
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static lambda(handler: lambda.IFunction): CustomResourceProvider;
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static topic(topic: sns.ITopic): CustomResourceProvider;
    private constructor();
}
/**
 * Properties to provide a Lambda-backed custom resource
 */
export interface CustomResourceProps {
    /**
     * The provider which implements the custom resource
     *
     * @example CustomResourceProvider.lambda(myFunction)
     * @example CustomResourceProvider.topic(myTopic)
     */
    readonly provider: CustomResourceProvider;
    /**
     * Properties to pass to the Lambda
     */
    readonly properties?: Properties;
    /**
     * For custom resources, you can specify AWS::CloudFormation::CustomResource
     * (the default) as the resource type, or you can specify your own resource
     * type name. For example, you can use "Custom::MyCustomResourceTypeName".
     *
     * Custom resource type names must begin with "Custom::" and can include
     * alphanumeric characters and the following characters: _@-. You can specify
     * a custom resource type name up to a maximum length of 60 characters. You
     * cannot change the type during an update.
     *
     * Using your own resource type names helps you quickly differentiate the
     * types of custom resources in your stack. For example, if you had two custom
     * resources that conduct two different ping tests, you could name their type
     * as Custom::PingTester to make them easily identifiable as ping testers
     * (instead of using AWS::CloudFormation::CustomResource).
     *
     * @see
     * https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cfn-customresource.html#aws-cfn-resource-type-name
     */
    readonly resourceType?: string;
}
/**
 * Custom resource that is implemented using a Lambda
 *
 * As a custom resource author, you should be publishing a subclass of this class
 * that hides the choice of provider, and accepts a strongly-typed properties
 * object with the properties your provider accepts.
 */
export declare class CustomResource extends Resource {
    private readonly resource;
    constructor(scope: Construct, id: string, props: CustomResourceProps);
    getAtt(attributeName: string): import("@aws-cdk/cdk").CfnReference;
}
