"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/cdk");
const fs = require("fs");
const lib_1 = require("../lib");
class DemoResource extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new lib_1.CustomResource(this, 'Resource', {
            provider: lib_1.CustomResourceProvider.lambda(new lambda.SingletonFunction(this, 'Singleton', {
                uuid: 'f7d4f730-4ee1-11e8-9c2d-fa7ae01bbebc',
                // This makes the demo only work as top-level TypeScript program, but that's fine for now
                code: new lambda.InlineCode(fs.readFileSync('integ.trivial-lambda-provider.py', { encoding: 'utf-8' })),
                handler: 'index.main',
                timeout: 300,
                runtime: lambda.Runtime.Python27,
            })),
            properties: props
        });
        this.response = resource.getAtt('Response').toString();
    }
}
/**
 * A stack that only sets up the CustomResource and shows how to get an attribute from it
 */
class SucceedingStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const resource = new DemoResource(this, 'DemoResource', {
            message: 'CustomResource says hello',
        });
        // Publish the custom resource output
        new cdk.CfnOutput(this, 'ResponseMessage', {
            description: 'The message that came back from the Custom Resource',
            value: resource.response
        });
    }
}
const app = new cdk.App();
new SucceedingStack(app, 'SucceedingStack');
app.run();
//# sourceMappingURL=data:application/json;base64,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