var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/account-provider/on-event-handler.lambda.ts
var on_event_handler_lambda_exports = {};
__export(on_event_handler_lambda_exports, {
  handler: () => handler
});
module.exports = __toCommonJS(on_event_handler_lambda_exports);
var import_aws_sdk = require("aws-sdk");
var organizationsClient;
async function handler(event) {
  var _a;
  console.log(`Request of type ${event.RequestType} received`);
  if (!organizationsClient) {
    organizationsClient = new import_aws_sdk.Organizations({ region: "us-east-1" });
  }
  console.log("Payload: %j", event);
  const { Email, AccountName, RoleName, IamUserAccessToBilling } = event.ResourceProperties;
  if (event.RequestType == "Create") {
    const response = await organizationsClient.createAccount({
      Email,
      AccountName,
      RoleName,
      IamUserAccessToBilling
    }).promise();
    console.log("Creating account: %j", response);
    return {
      Data: { ...event.ResourceProperties, CreateAccountStatusId: (_a = response.CreateAccountStatus) == null ? void 0 : _a.Id }
    };
  }
  return {
    ...event,
    Data: {
      ...event.ResourceProperties
    }
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
