import { NestedStack, NestedStackProps } from "aws-cdk-lib";
import { Function } from "aws-cdk-lib/aws-lambda";
import { Provider } from "aws-cdk-lib/custom-resources";
import { Construct } from "constructs";
export interface AccountProviderProps extends NestedStackProps {
}
/**
 * Creates a custom resource provider to asynchronously create Accounts in AWS organization. <strong>Account deletion is currently not supported!</strong>
 *
 * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#provider-framework
 */
export declare class AccountProvider extends NestedStack {
    /**
     * Retrieve AccountProvider as stack singleton resource.
     *
     * @see https://github.com/aws/aws-cdk/issues/5023
     */
    static getOrCreate(scope: Construct): AccountProvider;
    /**
     * Creates an Account and returns the CreateAccountStatus ID on Create. Passes the PhysicalResourceId on Update through. Fails on Delete.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#createAccount-property
     */
    readonly onEventHandler: Function;
    /**
     * Describes the CreateAccountStatus and returns the completions status. Fails on Delete.
     *
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/Organizations.html#describeCreateAccountStatus-property
     */
    readonly isCompleteHandler: Function;
    /**
     * The asynchronuos provider to create or update an Account.
     *
     * @see https://docs.aws.amazon.com/cdk/api/v1/docs/custom-resources-readme.html#asynchronous-providers-iscomplete
     */
    readonly provider: Provider;
    constructor(scope: Construct, id: string, props: AccountProviderProps);
}
